<?php

require('fpdf.php');

class PDF extends FPDF {

    function RoundedRect($x, $y, $w, $h, $r, $style = '') {
        $k = $this->k;
        $hp = $this->h;
        if ($style == 'F')
            $op = 'f';
        elseif ($style == 'FD' || $style == 'DF')
            $op = 'B';
        else
            $op = 'S';
        $MyArc = 4 / 3 * (sqrt(2) - 1);
        $this->_out(sprintf('%.2F %.2F m', ($x + $r) * $k, ($hp - $y) * $k));
        $xc = $x + $w - $r;
        $yc = $y + $r;
        $this->_out(sprintf('%.2F %.2F l', $xc * $k, ($hp - $y) * $k));

        $this->_Arc($xc + $r * $MyArc, $yc - $r, $xc + $r, $yc - $r * $MyArc, $xc + $r, $yc);
        $xc = $x + $w - $r;
        $yc = $y + $h - $r;
        $this->_out(sprintf('%.2F %.2F l', ($x + $w) * $k, ($hp - $yc) * $k));
        $this->_Arc($xc + $r, $yc + $r * $MyArc, $xc + $r * $MyArc, $yc + $r, $xc, $yc + $r);
        $xc = $x + $r;
        $yc = $y + $h - $r;
        $this->_out(sprintf('%.2F %.2F l', $xc * $k, ($hp - ($y + $h)) * $k));
        $this->_Arc($xc - $r * $MyArc, $yc + $r, $xc - $r, $yc + $r * $MyArc, $xc - $r, $yc);
        $xc = $x + $r;
        $yc = $y + $r;
        $this->_out(sprintf('%.2F %.2F l', ($x) * $k, ($hp - $yc) * $k));
        $this->_Arc($xc - $r, $yc - $r * $MyArc, $xc - $r * $MyArc, $yc - $r, $xc, $yc - $r);
        $this->_out($op);
    }

    function _Arc($x1, $y1, $x2, $y2, $x3, $y3) {
        $h = $this->h;
        $this->_out(sprintf('%.2F %.2F %.2F %.2F %.2F %.2F c ', $x1 * $this->k, ($h - $y1) * $this->k, $x2 * $this->k, ($h - $y2) * $this->k, $x3 * $this->k, ($h - $y3) * $this->k));
    }

    function WordWrap(&$text, $maxwidth) {
        $text = trim($text);
        if ($text === '')
            return 0;
        $space = $this->GetStringWidth(' ');
        $lines = explode("\n", $text);
        $text = '';
        $count = 0;

        foreach ($lines as $line) {
            $words = preg_split('/ +/', $line);
            $width = 0;

            foreach ($words as $word) {
                $wordwidth = $this->GetStringWidth($word);
                if ($wordwidth > $maxwidth) {
                    // Word is too long, we cut it
                    for ($i = 0; $i < strlen($word); $i++) {
                        $wordwidth = $this->GetStringWidth(substr($word, $i, 1));
                        if ($width + $wordwidth <= $maxwidth) {
                            $width += $wordwidth;
                            $text .= substr($word, $i, 1);
                        } else {
                            $width = $wordwidth;
                            $text = rtrim($text) . "\n" . substr($word, $i, 1);
                            $count++;
                        }
                    }
                } elseif ($width + $wordwidth <= $maxwidth) {
                    $width += $wordwidth + $space;
                    $text .= $word . ' ';
                } else {
                    $width = $wordwidth + $space;
                    $text = rtrim($text) . "\n" . $word . ' ';
                    $count++;
                }
            }
            $text = rtrim($text) . "\n";
            $count++;
        }
        $text = rtrim($text);
        return $count;
    }

    function vcell($c_width, $c_height, $x_axis, $text) {
        $w_w = $c_height / 3;
        $w_w_1 = $w_w + 2;
        $w_w1 = $w_w + $w_w + $w_w + 3;
        $len = strlen($text); // check the length of the cell and splits the text into 7 character each and saves in a array 

        $lengthToSplit = 26;
        if ($len > $lengthToSplit) {
            $w_text = str_split($text, $lengthToSplit);
            $this->SetX($x_axis);
            $this->Cell($c_width, $w_w_1, $w_text[0], '', '', 'C');
            if (isset($w_text[1])) {
                $this->SetX($x_axis);
                $this->Cell($c_width, $w_w1, $w_text[1], '', '', 'C');
            }
            $this->SetX($x_axis);
            $this->Cell($c_width, $c_height, '', '', 0, 'C', 0);
        } else {
            $this->SetX($x_axis);
            $this->Cell($c_width, $c_height, $text, '', 0, 'C', 0);
        }
    }
     function vcellPro($c_width, $c_height, $x_axis, $text) {
        $w_w = $c_height / 3;
        $w_w_1 = $w_w + 2;
        $w_w1 = $w_w + $w_w + $w_w + 3;
        $len = strlen($text); // check the length of the cell and splits the text into 7 character each and saves in a array 

        $lengthToSplit = 27;
        if ($len > $lengthToSplit) {
            $w_text = str_split($text, $lengthToSplit);
            $this->SetX($x_axis);
            $this->Cell($c_width, $w_w_1, $w_text[0], '', '', 'C');
            if (isset($w_text[1])) {
                $this->SetX($x_axis);
                $this->Cell($c_width, $w_w1, $w_text[1], '', '', 'C');
            }
            $this->SetX($x_axis);
            $this->Cell($c_width, $c_height, '', '', 0, 'C', 0);
        } else {
            $this->SetX($x_axis);
            $this->Cell($c_width, $c_height, $text, '', 0, 'C', 0);
        }
    }
         function vcellTip($c_width, $c_height, $x_axis, $text) {
        $w_w = $c_height / 3;
        $w_w_1 = $w_w + 2;
        $w_w1 = $w_w + $w_w + $w_w + 3;
        $len = strlen($text); // check the length of the cell and splits the text into 7 character each and saves in a array 

        $lengthToSplit = 30;
        if ($len > $lengthToSplit) {
            $w_text = str_split($text, $lengthToSplit);
            $this->SetX($x_axis);
            $this->Cell($c_width, $w_w_1, $w_text[0], '', '', 'C');
            if (isset($w_text[1])) {
                $this->SetX($x_axis);
                $this->Cell($c_width, $w_w1, $w_text[1], '', '', 'C');
            }
            $this->SetX($x_axis);
            $this->Cell($c_width, $c_height, '', '', 0, 'C', 0);
        } else {
            $this->SetX($x_axis);
            $this->Cell($c_width, $c_height, $text, '', 0, 'C', 0);
        }
    }
     function vcellTip37($c_width, $c_height, $x_axis, $text) {
        $w_w = $c_height / 3;
        $w_w_1 = $w_w + 2;
        $w_w1 = $w_w + $w_w + $w_w + 3;
        $len = strlen($text); // check the length of the cell and splits the text into 7 character each and saves in a array 

        $lengthToSplit = 40;
        if ($len > $lengthToSplit) {
            $w_text = str_split($text, $lengthToSplit);
            $this->SetX($x_axis);
            $this->Cell($c_width, $w_w_1, $w_text[0], '', '', 'C');
            if (isset($w_text[1])) {
                $this->SetX($x_axis);
                $this->Cell($c_width, $w_w1, $w_text[1], '', '', 'C');
            }
            $this->SetX($x_axis);
            $this->Cell($c_width, $c_height, '', 'LTRB', 0, 'C', 0);
        } else {
            $this->SetX($x_axis);
            $this->Cell($c_width, $c_height, $text, '', 0, 'C', 0);
        }
    }

}

?>
