<?php

function texto_mes($temp_texto_mes) {
    switch ($temp_texto_mes) {
        case 1 :
            $mest = "Enero";
            break;
        case 2 :
            $mest = "Febrero";
            break;
        case 3 :
            $mest = "Marzo";
            break;
        case 4 :
            $mest = "Abril";
            break;
        case 5 :
            $mest = "Mayo";
            break;
        case 6 :
            $mest = "Junio";
            break;
        case 7 :
            $mest = "Julio";
            break;
        case 8 :
            $mest = "Agosto";
            break;
        case 9 :
            $mest = "Septiembre";
            break;
        case 10 :
            $mest = "Octubre";
            break;
        case 11 :
            $mest = "Noviembre";
            break;
        case 12 :
            $mest = "Diciembre";
            break;
        default :
            $mest = "sin valor";
            break;
    }
    return ($mest);
}

function numeroALetra($dia) {
    $diaT = "NADA";

    switch ($dia) {
        case 0:
            $diaT = "CERO";
            break;
        case 1:
            $diaT = "UNA";
            break;
        case 2:
            $diaT = "DOS";
            break;
        case 3:
            $diaT = "TRES";
            break;
        case 4:
            $diaT = "CUATRO";
            break;
        case 5:
            $diaT = "CINCO";
            break;
        case 6:
            $diaT = "SEIS";
            break;
        case 7:
            $diaT = "SIETE";
            break;
        case 8:
            $diaT = "OCHO";
            break;
        case 9:
            $diaT = "NUEVE";
            break;
        case 10:
            $diaT = "DIEZ";
            break;
        case 11:
            $diaT = "ONCE";
            break;
        case 12:
            $diaT = "DOCE";
            break;
        case 13:
            $diaT = "TRECE";
            break;
        case 14:
            $diaT = "CATORCE";
            break;
        case 15:
            $diaT = "QUINCE";
            break;
        case 16:
            $diaT = "DIECISEIS";
            break;
        case 17:
            $diaT = "DIECISIETE";
            break;
        case 18:
            $diaT = "DIECIOCHO";
            break;
        case 19:
            $diaT = "DIECINUEVE";
            break;
        case 20:
            $diaT = "VEINTE";
            break;
        case 21:
            $diaT = "VEINTIUNO";
            break;
        case 22:
            $diaT = "VEINTIDOS";
            break;
        case 23:
            $diaT = "VEINTITRES";
            break;
        case 24:
            $diaT = "VEINTICUATRO";
            break;
        case 25:
            $diaT = "VEINTICINCO";
            break;
        case 26:
            $diaT = "VEINTISEIS";
            break;
        case 27:
            $diaT = "VEINTISIETE";
            break;
        case 28:
            $diaT = "VEINTIOCHO";
            break;
        case 29:
            $diaT = "VEINTINUEVE";
            break;
        case 30:
            $diaT = "TREINTA";
            break;
        case 31:
            $diaT = "TREINTAYUNO";
            break;
        default:
            return false;
    }
    return $diaT;
}

function formatea_fecha($fecha) {
    $trozos = explode("-", $fecha);
    $ftemp_final = $trozos [2] . " de " . texto_mes($trozos [1]) . " del " . $trozos [0];
    return $ftemp_final;
}

$today = Date("Y-m-d");
$today_hora = Date("Y-m-d H:i:s");

$grab_time = date('H');
$time = $grab_time;
$Min = date("i");
$segundo = date("s");
$hora = "$time:$Min:$segundo";

$ip = getenv("REMOTE_ADDR");

$pon_fecha = Date("j") . " de " . texto_mes(Date("n")) . " de " . Date("Y");

$urlpath = "http://" . $_SERVER ["HTTP_HOST"] . $_SERVER ["REQUEST_URI"];
$urlmain = "http://" . $_SERVER ["HTTP_HOST"] . "" . dirname($_SERVER ["PHP_SELF"]) . "/main.php";

function imprime_array($array) {
    echo "<div align='left'><pre>";
    print_r($array);
    echo "</pre></div>";
    return null;
}

function limpiaCampo($campo) {
    $campo = trim($campo);
    return $campo;
}

function estaVacio($campo, $msg) {
    if (is_array($campo)) {
        // echo "<br>$campo es un array<br>";
        // exit();
        return true;
    }
    $campo = trim($campo);
    if (empty($campo)) {
        echo "<br><br>";
        error("$msg");
        echo "<bR><br>";
        return FALSE;
    }
    return TRUE;
}

function codificaArray($matriz, $mayus) {
    foreach ($matriz as $id => $valor) {
        if (is_array($valor))
            continue;
        // codificaArray($valor, $mayus);
        else {
            if ($mayus) {
                $valor = strtoupper(mb_strtoupper($valor, 'UTF-8'));
            }
            $valor = (!get_magic_quotes_gpc()) ? trim(addslashes($valor)) : trim(mysqli_real_escape_string($_SESSION ["link"], $valor));

            $matriz [$id] = utf8_decode($valor);
        }
    }
    return $matriz;
}

function codificaParaForm($matriz) {
    foreach ($matriz as $id => $valor) {
        if (is_array($valor))
            continue;

        $matriz [$id] = str_replace("<br />", "", $valor);
        $matriz [$id] = htmlspecialchars($matriz [$id], ENT_QUOTES);
    }
    return $matriz;
}

function limpiaArray($arreglo) {
    // imprime_array($arreglo);
    foreach ($arreglo as $id => $valor) {
        if (is_array($valor)) {
            continue;
        }

        $arreglo [$id] = trim($valor);
        $arreglo [$id] = addslashes($arreglo [$id]);
        $arreglo [$id] = utf8_decode($arreglo [$id]);
    }
    // imprime_array($arreglo);
    return $arreglo;
}

function error($msg) {
    echo "<span class='error'>" . stripslashes("$msg") . "</span>";
}

function titulo($msg) {
    echo "
	<div class='header2'>
	  	<br>
		$msg
		<br><br>
	</div>	
	";
}

function login($user, $pass) {

    $_SESSION["login"]->isRoot = false;

    if ($user == "fgalicia" and $pass == "4a14cfd7cf924b76ca897ee2434796f2") {
        $_SESSION["login"]->isRoot = true;
        $_SESSION ["login"]->subsistema = 0;
        return true;
    } else if ($user == "mediasuperior" and $pass == "8872afa111729929189ba081c928568e") {
        $_SESSION["login"]->isRoot = true;
        $_SESSION ["login"]->subsistema = 0;
        return true;
    }

    $login = new sql ();
    // imprime_array($_SESSION);
    $tmp = $login->datosEnArray("
		select u.subsistema, u.inicial, u.user,p.cct, p.msPlantel, p.id_msPlantel
		from msSubsistema u join msPlantel p using (id_msSubsistema)
		where p.cct='$user' and p.pass='$pass'
		limit 1
	");
    return $tmp;
}

function esSubsistema($user, $pass) {
    $login = new sql();
    $tmp = $login->datosEnArray("select * from msSubsistema where user like '$user' and  pass ='$pass' ");
    return $tmp;
}

function obtienePermisos() {
    $perm = new sql ();
    $tmp = $perm->datosEnArray("
		select up.usuarioPermiso, up.id_usuarioPermiso, un.id_usuarioNivel
		from usuarioPermiso up join usuarioNivel un  using (id_usuarioPermiso)
		where un.id_usuario=" . $_SESSION ["login"]->id_usuario);
    return $tmp;
}

function verificaPermiso($permiso) {

    if ($_SESSION["login"]->id_departamento == 1)
        return true;

    $sql = new sql ();
    $query = "
		select up.usuarioPermiso
		from usuarioPermiso up join usuarioNivel un  using (id_usuarioPermiso)
		where un.id_usuario=" . $_SESSION ["login"]->id_usuario . " and up.usuarioPermiso ='$permiso' ";

    $temp = $sql->datosEnArray($query);

    if (count($temp) == 0)
        return false;
    else
        return true;
}

function redireccion($destino, $segundos = 0) {
    echo "
        <HEAD>
            <META HTTP-EQUIV='Refresh' CONTENT='$segundos; URL=$destino'
        </HEAD>
   ";
}

function obtieneUno($tabla, $campo, $where) {
    if (!estaVacio($tabla, "Error. tabla --> vacio. obtieneUno"))
        return FALSE;
    if (!estaVacio($campo, "Error. campo --> vacio. obtieneUno"))
        return FALSE;
    if (!estaVacio($where, "Error. where --> vacio. obtieneUno"))
        return FALSE;

    $sql = new sql ();
// 	echo "select $campo from $tabla where $where limit 1";
    $sql->runQuery("select $campo from $tabla where $where limit 1");
    $datos = $sql->data();

    return $datos [$campo];
}

function cuentaRegistros($tabla, $where = "") {
    if (!estaVacio($tabla, "Error. tabla --> vacio. cuentaRegistros"))
        return FALSE;
    // if (!estaVacio($where, "Error. where --> vacio. cuentaRegistros"))
    // return FALSE;

    $where2 = "";
    if (!empty($where))
        $where2 = "where $where";

    $sql = new sql ();
    $sql->runQuery("select * from $tabla $where2");

    return $sql->rows();
}

function eliminaRegistros($tabla, $where) {
    if (!estaVacio($tabla, "Error. tabla --> vacio. eliminaRegistros"))
        return FALSE;

    if (count($where) != 0) {
        $were = " where ";
        foreach ($where as $i => $v) {
            $were .= " $i = '$v' and";
        }
        $were = rtrim($were, "and");
    }

    $query = "delete from $tabla $were";
// 	exit();

    $sql = new sql ();

    if ($sql->runQuery($query))
        return true;
    else
        return FALSE;
}

function actualizaDatos($table, $actualizar, $where) {
    $sql = new sql ();
    if (!estaVacio($table, "Error. table --> vacio. ActualizaDatos"))
        return FALSE;
    if (count($actualizar) == 0) {
        echo "Error. id --> vacio. ActualizaDatos";
        return FALSE;
    }
    if (!estaVacio($where, "Error. tablaValores --> vacio. ActualizaDatos"))
        return FALSE;

    $camposTabla = obtieneCamposTabla($table);

    // armamos ids
    foreach ($actualizar as $idi => $valori) {
        if (!in_array($idi, $camposTabla))
            continue;

        $campos .= "$idi= '" . $valori . "', ";
    }
    $campos = rtrim($campos, ", ");

    // echo "update $table set $campos where $where";

    if ($sql->runQuery("update $table set $campos where $where"))
        return TRUE;
    else
        return false;
}

function obtieneCamposUnique($tabla) {
    $sql = new sql ();

    $datosCampos = $sql->datosEnArray("describe $tabla");
    // imprime_array($datosCampos);

    $campos = array();

    foreach ($datosCampos as $idx => $fieldName) {
        if ($fieldName ["Key"] == "UNI")
            $campos [] = $fieldName ["Field"];
    }

    // imprime_array($campos);
    return ($campos);
}

function obtieneCamposTabla($tabla) {
    $sql = new sql ();

    $datosCampos = $sql->datosEnArray("describe $tabla");
    // imprime_array($datosCampos);

    $campos = array();

    foreach ($datosCampos as $idx => $fieldName) {
        $campos [] = $fieldName ["Field"];
    }

    // imprime_array($campos);
    return ($campos);
}

function insertaDatos($table, $tableValues, $returnLastId) {
    if (count($tableValues) == 0) {
        echo "Error. tabla --> vacio. InsertaDatos";
        require ("abajo.php");
        exit();
    }

    $camposTabla = obtieneCamposTabla($table);

    $sql = new sql ();

    // imprime_array($camposTabla);
    // exit;

    foreach ($tableValues as $id => $valor) {
        if (!in_array($id, $camposTabla))
            continue;

        $fields .= "$id,";
        $values .= "'$valor',";
    }

    $fields = rtrim($fields, " , ");
    $values = rtrim($values, " , ");

    // echo "insert into $table($fields) values($values)";
    // exit();

    $consulta = $sql->runQuery("insert into $table($fields) values($values)");
    if (!$consulta) {
        return false;
    }
    if ($returnLastId) {
        $sql->runQuery("select LAST_INSERT_ID() as last");
        $data = $sql->data();
        return $data ["last"];
    } else
        return TRUE;
}

function insertaDatosDirecto($table, $tableValues, $returnLastId) {
    if (count($tableValues) == 0) {
        echo "Error. tabla --> vacio. InsertaDatos";
        require ("abajo.php");
        exit();
    }

    $sql = new sql ();

    foreach ($tableValues as $id => $valor) {
        $fields .= "$id,";
        $values .= "'$valor',";
    }

    $fields = rtrim($fields, " , ");
    $values = rtrim($values, " , ");

    // echo "insert into $table($fields) values($values)";
    // exit();

    $sql->runQuery("insert into $table($fields) values($values)");

    if ($returnLastId) {
        $sql->runQuery("select LAST_INSERT_ID() as last");
        $data = $sql->data();
        return $data ["last"];
    } else
        return TRUE;
}

function comparaFechas($fecha1, $fecha2) {
    // echo $fecha1." ==> ";
    $fechar1 = strtotime($fecha1);

    // echo $fecha2." ==> ";
    $fechar2 = strtotime($fecha2);

    if ($fechar1 == $fechar2)
        return "ig";
    else if ($fechar1 < $fechar2)
        return "f1me";
    else
        return "f1ma";
}

function obtieneDatosProveedor() {
    $sql = new sql ();

    return $sql->datosEnArray("
			select p.id_proveedor, p.proveedor, p.representante, p.descripcion, p.telefono, p.vigente, DATE(p.fechaReg) as fecha, TIME(p.fechaReg) as hora,
				CONCAT(p.direccion,', ',m.municipio,', ',e.estado) as origen, u.nombre
			from proveedor p join municipio m using(id_municipio)
				join estado e using (id_estado)
				join acceso a using(id_acceso)
				join usuario u using(id_usuario)
			where p.vigente='S'
			order by p.id_proveedor ASC
		");
}

function obtieneDatosCliente() {
    $sql = new sql ();

    return $sql->datosEnArray("
			select c.id_cliente, c.cliente, c.telefono, c.rfc, c.cp, c.vigente, DATE(c.fechaReg) as fecha, TIME(c.fechaReg) as hora,
				CONCAT(c.direccion,', ',m.municipio,', ',e.estado) as direccion, u.nombre
			from cliente c join municipio m using(id_municipio)
				join estado e using (id_estado)
				join acceso a using(id_acceso)
				join usuario u using(id_usuario)
			where c.vigente='1'
			order by c.id_cliente ASC
		");
}

function obtieneDatosArticulo($id = 0) {
    $idArt = ($id == 0) ? $_SESSION ["id_articulo"] : $id;

    $sql = new sql ();
    $datos = $sql->datosEnArray("select ca.*, m.mercancia, ma.marca
	from catalogoArticulo ca join mercancia m using(id_mercancia)
		join marca ma using(id_marca)
	where ca.id_catalogoArticulo = '$idArt'");

    $datos = $datos [0];
    return $datos;
}

function inventarioEstadoActual() {
    $sql = new sql ();
    $datos = $sql->datosEnArray("
		select e.existencias, ca.id_catalogoArticulo, ca.modelo, ca.partNumber, ca.observaciones, DATE(ca.fechaReg) as fechaReg, TIME(ca.fechaReg) as horaReg,
			ma.marca, m.mercancia, p.proveedor, ca.clave
		from entradas e  join catalogoArticulo ca using(id_catalogoArticulo)
			join marca ma using(id_marca)
			join mercancia m using(id_mercancia)
			join proveedor p using(id_proveedor)
		order by e.id_entradas
	");
    return $datos;
}

function inventarioReporteEntradas($f1, $f2) {
    $sql = new sql ();
    $datos = $sql->datosEnArray("
		select ca.modelo, ca.partNumber, ca.observaciones as observacionesCa, ca.clave, me.mercancia, ma.marca, 
			e.ns, e.cantidad, e.observaciones, DATE(e.fechaReg) as fecha, TIME(e.fechaReg) as hora, p.proveedor
		from catalogoArticulo ca join mercancia me using(id_mercancia)
			join marca ma using(id_marca)
			join entradas e using(id_catalogoArticulo)
			join proveedor p using(id_proveedor)
		where DATE(e.fechaReg) between '$f1' and '$f2'
		order by id_entradas
	");
    return $datos;
}

function inventarioReporteCatalogoArticulo() {
    $sql = new sql ();
    $datos = $sql->datosEnArray("
		select ca.modelo, ca.partNumber, ca.observaciones, ca.clave, me.mercancia, ma.marca,
			DATE(ca.fechaReg) as fecha, TIME(ca.fechaReg) as hora
		from catalogoArticulo ca join mercancia me using(id_mercancia)
			join marca ma using(id_marca)
		order by id_catalogoArticulo
	");
    return $datos;
}

function inventarioReporteSalidas($f1, $f2) {
    $sql = new sql ();
    $datos = $sql->datosEnArray("
		select ca.modelo, ca.partNumber, ca.observaciones as observacionesCa, ca.clave, me.mercancia, ma.marca, 
		e.ns, s.observaciones, DATE(s.fechaReg) as fecha, TIME(s.fechaReg) as hora,
		SUM(ds.cantidad) as cantidad, s.id_salida
	from catalogoArticulo ca join mercancia me using(id_mercancia)
		join marca ma using(id_marca)
		join entradas e using(id_catalogoArticulo)
		join detalleSalidas ds using(id_entradas)
		join salidas s using(id_salida)
	where DATE(s.fechaReg) between '$f1' and '$f2'
	group by s.id_salida
	");
    return $datos;
}

function listaNoticias($limite) {
    $sql = new sql ();
    $datos = $sql->datosEnArray("
		select bn.*, bni.id_boletinNoticiaImagenes, bni.nombreImagen, bni.principal
		from boletinNoticia bn left join boletinNoticiaImagenes bni on(bn.id_boletinNoticia= bni.id_boletinNoticia and bni.principal='S')
		where bn.id_boletinNoticiaStatus='2'
		order by bn.id_boletinNoticia DESC limit $limite
	");
    return $datos;
}

function obtieneNoticia($id) {
    $id = intval($id);
    $id = mysqli_real_escape_string($_SESSION ["link"], $id);

    $sql = new sql ();
    $datos = $sql->datosEnArray("
	select bn.numero, bn.titulo, bn.cuerpo, DATE(bn.fechaReg) as fecha, TIME(bn.fechaReg) as hora, d.departamento 
	from boletinNoticia bn join acceso a using(id_acceso)
		join usuario u using(id_usuario)
		join usuarioNivel un using (id_usuarioNivel)
		join departamento d using(id_departamento) 
	where id_boletinNoticia='$id'
	");
    return $datos [0];
}

function obtieneImagenesDeNoticia($id) {
    $id = intval($id);
    $id = mysqli_real_escape_string($_SESSION ["link"], $id);

    $sql = new sql ();
    $datos = $sql->datosEnArray("
	select id_boletinNoticiaImagenes, nombreImagen, titulo, principal
	from boletinNoticiaImagenes
	 where id_boletinNoticia='$id'
	 	and tipo='1'
	 	and vigente='S'
	");
    return $datos;
}

function obtieneAudioDeNoticia($id) {
    $id = intval($id);
    $id = mysqli_real_escape_string($_SESSION ["link"], $id);

    $sql = new sql ();
    $datos = $sql->datosEnArray("
	select id_boletinNoticiaImagenes, nombreImagen
	from boletinNoticiaImagenes
	 where id_boletinNoticia='$id'
	 	and tipo='2'
	 	and vigente='S'
	");
    return $datos;
}

function obtieneNoticiasPorMes($fecha) {
    // echo "<br>".$fecha;
    $sql = new sql ();
    $datos = $sql->datosEnArray("
	select b.* 
	from boletinNoticia b
	where year('$fecha') = year(fechaReg) and month('$fecha') = month(fechaReg)
		and id_boletinNoticiaStatus='2'
		order by b.id_boletinNoticia desc
	");
    return $datos;
}

function obtieneDatosEscuelaCaptura($cct) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from escuelaCaptura where cct like '$cct'");
    return $temp;
}

function obtieneDatosEscuelaPlantel($id) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from escuelaPlantel where id_escuelaPlantel ='" . intval($id) . "'");
    return $temp;
}

function obtieneAlumnosPorGrupo($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaAlumnosPorGrupo where cct like '$id_escuelaPlantel'");
    return $temp;
}

// judaav
function obtieneProfPorGrado($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaProfPorGrado where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneAulasDeMedios($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaAulasDeMedios where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneDocentesPorAsignatura($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaDocentesPorAsignatura where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneProgramaEmexico($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaProgramaEmexico where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneProgramaEnciclomedia($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaProgramaEnciclomedia where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneProgramaUnete($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaProgramaUnete where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneExtras($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaExtras where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneProgramaHdt($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaProgramaHdt where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneProgramaAulaMedios($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaProgramaAulaMedios where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneProgramaSalaComp($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaProgramaSalaComp where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneProgramaAdPropia($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from capturaProgramaAdPropia where cct like '$id_escuelaPlantel'");
    return $temp;
}

function obtieneescuelaPersonal($id_escuelaPlantel) {
    $sql = new sql ();
    $temp = $sql->datosEnArray("select * from escuelaPersonal where cct like '$id_escuelaPlantel'");
    return $temp;
}

// judaav
function GenerarPassword($longitud = 0, $soloLetras = false) {

    // Verifica la longitud de la clave a generar
    if (!is_numeric($longitud) || $longitud <= 0) {
        $longitud = 10;
    }

    // Caracteres a utilizar para generar la contrase�a y los reordena
    // aleatoriamente
    if ($soloLetras)
        $caracteres = str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ');
    else
        $caracteres = str_shuffle('abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ');

    // Concatena los caracteres al azar
    $password = '';
    for ($i = 0; $i < $longitud; $i ++) {
        $key = rand(0, strlen($caracteres) - 1);
        $password .= substr($caracteres, $key, 1);
    }

    return $password;
}

function soporteObtieneDatosTicket($ticket) {
    $ticket = intval($ticket);

    $sql = new sql ();
    $datos = $sql->datosEnArray("
		select t.*,
			DATE(t.fechaReg) as fechaRegT, TIME(t.fechaReg) as horaRegT,
			d.*,
			scf.*,
			ste.id_soporteCategoriaFalla as id_soporteCategoriaFallaInicial, ste.id_soporteTipoDeEquipo as id_soporteTipoDeEquipoInicial, ste.soporteTipoDeEquipo as soporteTipoDeEquipoInicial,
			stf.*,
			u.nombre as nombreReporto, u.correo as correoReporto, u.usern as usernReporto,
			us2.id_usuario as id_tecnicoAsignado, us2.nombre as tecnicoAsignado,
			usa.nombre as nombreRegistro, usa.id_usuario as id_usuarioRegistro,
			te.*, 
			m.id_soporteMarca, m.soporteMarca,
			us.nombre as asignadoNombre, us.correo as asignadoCorreo, us.usern as asignadoUsern, 
			ea.modelo, ea.ns, ea.inventario, ea.observaciones, ea.ext,
			sta.*,
			ct.*,
			sm.*,
			smt.*,
			si.*,
			pmod.*,
			pmar.*,
			pvel.*,
			hd.*,
			uo.*,
			cerr.observaciones as cerrObserva, DATE(cerr.fechaREG) as cerrFechaReg, TIME(cerr.fechaREG) as cerrHora
		from soporteTicketServicio t join usuario u using(id_usuario)
			join usuario us2 on (us2.id_usuario = t.id_usuarioAsignado)
			join departamento d on (d.id_departamento = t.id_departamento) 
			join soporteTipoFalla stf using(id_soporteTipoFalla)
			join soporteCategoriaFalla scf using(id_soporteCategoriaFalla)
			join soporteTipoDeEquipo ste on (ste.id_soporteTipoDeEquipo = t.id_soporteTipoDeEquipo)
			join acceso a on (a.id_acceso=t.id_acceso)
			join usuario usa on (usa.id_usuario = a.id_usuario)
			join soporteEquipoAsignado ea using(id_soporteEquipoAsignado)
			join soporteTicketServicioStatus sta using (id_soporteTicketServicioStatus)
			join soporteTipoDeEquipo te on (te.id_soporteTipoDeEquipo = ea.id_soporteTipoDeEquipo)
			join soporteMarca m using(id_soporteMarca)
			join usuario us on (us.id_usuario = ea.id_usuario)
			join soporteComputadoraTipo ct using(id_soporteComputadoraTipo)
			join soporteMonitorTipo sm using(id_soporteMonitorTipo)
			join soporteMonitorTamano smt using(id_soporteMonitorTamano)
			join soporteImpresoraTipo si using(id_soporteImpresoraTipo)
			left join soporteCaracCpu cpu on (cpu.id_soporteEquipoAsignado = ea.id_soporteEquipoAsignado)
			left join soporteMemoriaRam ram using(id_soporteMemoriaRam)
			left join soporteProcesadorModelo pmod using (id_soporteProcesadorModelo)
			left join soporteProcesadorMarca pmar using(id_soporteProcesadorMarca)
			left join soporteProcesadorVelocidad pvel using(id_soporteProcesadorVelocidad)
			left join soporteHdCapacidad hd using(id_soporteHdCapacidad)
			left join soporteUnidadOptica uo using(id_soporteUnidadOptica)
			left join soporteTicketCerrado cerr on (t.id_soporteTicketServicio = cerr.id_soporteTicketServicio)
		where t.id_soporteTicketServicio in ('$ticket') 
	");

    return $datos;
}

function soporteMuestraCabeceraTicket($datos) {
    ?>

    <div class="redondo">
        <table border="0" width="800px">
            <tr>
                <td width="120px" class="tdCabecera">Folio</td>
                <td width="5px"></td>
                <td class="tdCabeceraTexto"><strong><?php echo error($datos["folio"]) ?></strong></td>
            </tr>
            <tr>
                <td class="tdCabecera">Status</td>
                <td></td>
                <td class="tdCabeceraTexto"><strong><?php echo error($datos["soporteTicketServicioStatus"]) ?></strong></td>
            </tr>
            <tr>
                <td class="tdCabecera">Usuario que report&oacute;</td>
                <td></td>
                <td class="tdCabeceraTexto"><?php echo $datos["nombreReporto"] . " [$datos[correoReporto]]" ?></td>
            </tr>
            <tr>
                <td class="tdCabecera">Area</td>
                <td></td>
                <td class="tdCabeceraTexto"><?php echo $datos["departamento"] ?></td>
            </tr>
            <tr>
                <td class="tdCabecera">Falla reportada</td>
                <td></td>
                <td class="tdCabeceraTexto">[<?php echo $datos["soporteCategoriaFalla"] . "-" . $datos["soporteTipoDeEquipoInicial"] . "] - " . $datos["soporteTipoFalla"] ?></td>
            </tr>
            <tr>
                <td class="tdCabecera">Observaciones</td>
                <td></td>
                <td class="tdCabeceraTexto"><?php echo stripslashes($datos["falla"]) ?></td>
            </tr>
            <tr>
                <td class="tdCabecera">Equipo a reparar</td>
                <td></td>
                <td class="tdCabeceraTexto">
    <?php
    if ($datos ["id_soporteEquipoAsignado"] == 1) {
        error("NO SE HA SELECCIONADO EQUIPO ALGUNO");
    } else {
        // mostramos caracteristicas del equipo
        echo "Detalles abajo";
    }
    ?>
                </td>
            </tr>

            <tr>
                <td class="tdCabecera">Ingeniero asignado</td>
                <td></td>
                <td class="tdCabeceraTexto">
    <?php
    if ($datos ["id_tecnicoAsignado"] == 1) {
        error("NO SE HA ASIGNADO INGENIERO DE SOPORTE");
    } else {
        error($datos ["tecnicoAsignado"]);
    }
    ?>
                </td>
            </tr>
            <tr>
                <td class="tdCabecera">Registrado por</td>
                <td></td>
                <td class="tdCabeceraTexto"><?php echo stripslashes($datos["nombreRegistro"]) . " el " . formatea_fecha($datos["fechaRegT"]) . " a las $datos[horaRegT]" ?></td>
            </tr>
        </table>
    </div>
    <?php
}

function soporteListaEquiposArea($ticket, $depto, $user, $equipo, $hw = 0) {
    if ($equipo == 1)
        return;

    $sql = new sql ();

    $where = ($depto != 0) ? " u.id_departamento = '$depto'" : " u.id_usuario='$user'";
    $where = (intval($equipo) > 0) ? " e.id_soporteEquipoAsignado ='$equipo' " : $where;
    $and = (intval($equipo) == 0) ? "and e.id_soporteEquipoAsignado not in (
	 		select distinct(sts.id_soporteEquipoAsignado) from soporteTicketServicio sts join soporteEquipoAsignado sea using(id_soporteEquipoAsignado)
			where sts.id_soporteTicketServicioStatus != 4 and sea.id_soporteEquipoAsignado != 1
			)" : "";
    $andHw = ($hw > 0) ? " and  te.id_soporteTipoDeEquipo='$hw'" : "";

    $query = "
	 	select e.*,
	 	m.soporteMarca,
	 	u.nombre,
	 	te.soporteTipoDeEquipo,
	 	ct.soporteComputadoraTipo,
	 	mt.soporteMonitorTipo,
	 	mta.soporteMonitorTamano,
	 	it.soporteImpresoraTipo
	 	from soporteEquipoAsignado e join soporteMarca m using(id_soporteMarca)
	 		join usuario u using(id_usuario)
	 		join soporteTipoDeEquipo te using (id_soporteTipoDeEquipo)
	 		join soporteComputadoraTipo ct using(id_soporteComputadoraTipo)
	 		join soporteMonitorTipo mt using(id_soporteMonitorTipo)
	 		join soporteMonitorTamano mta using (id_soporteMonitorTamano)
	 		join soporteImpresoraTipo it using(id_soporteImpresoraTipo)
	 	where $where and idsoporteEquipoStatus='2'
	 	$and $andHw
	 	order by te.soporteTipoDeEquipo 
	 ";

    $datos = $sql->datosEnArray($query);
    if (count($datos) == 0) {
        error("<bR><br><hr>No hay equipos registrados para esta area<hr><br><br>");
        return false;
    }

    // imprime_array($datos);
    ?>
    <div>
    <?php
    if ($equipo == 0) {
        echo "<p align='left'>";
        error("<br>Seleccione un equipo para asignarlo a este Ticket de soporte:<br>");
        echo "</p>";
    }
    ?>
        <table id="listaEquipos" width="850px" class="bordered">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Tipo de Equipo</th>
                    <th>Marca</th>
                    <th>Modelo</th>
                    <th>NS</th>
                    <th>Inventario</th>
                    <th>Responsable</th>
                    <th>Tipo Computadora</th>
                    <th>Tipo Impresora</th>
                    <th>Tipo Monitor</th>
                    <th>Tama&ntilde;o Monitor</th>
                </tr>
            </thead>
    <?php
    $x = 0;
    foreach ($datos as $id => $valor) {
        $x ++;
        ?>
                <tr class="<?php echo (intval($equipo) > 0) ? "" : "seleccionAsignar" ?>"
                    tick="<?php echo $ticket ?>" val="<?php echo $valor["id_soporteEquipoAsignado"] ?>">
                    <td><?php echo $x ?></td>
                    <td><?php echo $valor["soporteTipoDeEquipo"] ?></td>
                    <td><?php echo $valor["soporteMarca"] ?></td>
                    <td><?php echo $valor["modelo"] ?></td>
                    <td><?php echo $valor["ns"] ?></td>
                    <td><?php echo $valor["inventario"] ?></td>
                    <td><?php echo $valor["nombre"] ?></td>
                    <td><?php echo ($valor["id_soporteComputadoraTipo"] == 1) ? "" : $valor["soporteComputadoraTipo"] ?></td>
                    <td><?php echo ($valor["id_soporteImpresoraTipo"] == 1) ? "" : $valor["soporteImpresoraTipo"] ?></td>
                    <td><?php echo ($valor["id_soporteMonitorTipo"] == 1) ? "" : $valor["soporteMonitorTipo"] ?></td>
                    <td><?php echo ($valor["id_soporteMonitorTamano"]) ? "" : $valor["soporteMonitorTamano"] ?></td>
                </tr>
        <?php
    }
    ?>

        </table>
    </div>
            <?php
        }

        function soporteMuestraHistorialSeguimientoTicket($ticket) {
            $sql = new sql ();

            $ticket = intval($ticket);

            $query = "
		select h.observaciones, DATE(h.fechaReg) as fecha, TIME(h.fechaReg) as hora,
		ase.soporteAccionServicio,
		c.soporteCategoriaFalla,
		u.nombre
		from soporteHistorialTicket h join soporteAccionServicio ase using(id_soporteAccionServicio)
			join soporteCategoriaFalla c using(id_soporteCategoriaFalla)
			join acceso a using (id_acceso)
			join usuario u using (id_usuario)
		where h.id_soporteTicketServicio ='$ticket'
	";

            $datos = $sql->datosEnArray($query);

            if (count($datos) == 0 || empty($datos)) {
                echo '<br><br><div align="center" class="error" id="bloqueHistorial"><strong>NO HAY HISTORIAL DE SERVICIOS REGISTRADOS</strong></div>';
                return;
            }
            ?>
    <br>
    <div id="bloqueHistorial">
        <div align="center" class="error">
            <strong>HISTORIAL DE SEGUIMIENTO</strong>
        </div>
        <table width="850px" class="bordered" id="listaEquipos">
            <thead>
                <tr>
                    <th>No</th>
                    <th>Categoria</th>
                    <th>Acci&oacute;n realizada</th>
                    <th>Observaciones</th>
                    <th>Fecha</th>
                    <th>Realiz&oacute;</th>
                </tr>
            </thead>
    <?php
    $x = 0;
    foreach ($datos as $id => $valor) {
        $x ++;
        echo "
		 		<tr>
		 			<td>$x</td>
		 			<td>" . $valor ["soporteCategoriaFalla"] . "</td>
		 			<td>" . $valor ["soporteAccionServicio"] . "</td>
		 			<td>" . $valor ["observaciones"] . "</td>
		 			<td>" . formatea_fecha($valor ["fecha"]) . " <br> a las " . $valor ["hora"] . "</td>
		 			<td>" . $valor ["nombre"] . "</td>
		 		</tr>
		 		";
    }
    ?>
        </table>
    </div>
    <?php
}

function listaTickets($idTec = 0) {
    $sql = new sql ();
    $query = "
		select t.*,
			DATE(t.fechaReg) as fechaRegT, TIME(t.fechaReg) as horaRegT,
			d.*,
			scf.*,
			ste.id_soporteCategoriaFalla as id_soporteCategoriaFallaInicial, ste.id_soporteTipoDeEquipo as id_soporteTipoDeEquipoInicial, ste.soporteTipoDeEquipo as soporteTipoDeEquipoInicial,
			stf.*,
			u.nombre as nombreReporto, u.correo as correoReporto, u.usern as usernReporto,
			us2.id_usuario as id_tecnicoAsignado, us2.nombre as tecnicoAsignado,
			usa.nombre as nombreRegistro, usa.id_usuario as id_usuarioRegistro,
			te.*, 
			m.id_soporteMarca, m.soporteMarca,
			us.nombre as asignadoNombre, us.correo as asignadoCorreo, us.usern as asignadoUsern, 
			ea.modelo, ea.ns, ea.inventario, ea.observaciones,
			sta.*,
			ticeca.*,
			ct.*,
			sm.*,
			smt.*,
			si.*,
			pmod.*,
			pmar.*,
			pvel.*,
			hd.*,
			uo.*
		from soporteTicketServicio t join usuario u using(id_usuario)
			join usuario us2 on (us2.id_usuario = t.id_usuarioAsignado)
			join departamento d on (d.id_departamento = t.id_departamento) 
			join soporteTipoFalla stf using(id_soporteTipoFalla)
			join soporteCategoriaFalla scf using(id_soporteCategoriaFalla)
			join soporteTipoDeEquipo ste on (ste.id_soporteTipoDeEquipo = t.id_soporteTipoDeEquipo)
			join acceso a on (a.id_acceso=t.id_acceso)
			join usuario usa on (usa.id_usuario = a.id_usuario)
			join soporteEquipoAsignado ea using(id_soporteEquipoAsignado)
			join soporteTicketServicioStatus sta using (id_soporteTicketServicioStatus)
			left join soporteTicketCerrado tice on(tice.id_soporteTicketServicio = t.id_soporteTicketServicio)
			left join soporteTicketCerradoCausa ticeca using(id_soporteTicketCerradoCausa)
			join soporteTipoDeEquipo te on (te.id_soporteTipoDeEquipo = ea.id_soporteTipoDeEquipo)
			join soporteMarca m using(id_soporteMarca)
			join usuario us on (us.id_usuario = ea.id_usuario)
			join soporteComputadoraTipo ct using(id_soporteComputadoraTipo)
			join soporteMonitorTipo sm using(id_soporteMonitorTipo)
			join soporteMonitorTamano smt using(id_soporteMonitorTamano)
			join soporteImpresoraTipo si using(id_soporteImpresoraTipo)
			left join soporteCaracCpu cpu on (cpu.id_soporteEquipoAsignado = ea.id_soporteEquipoAsignado)
			left join soporteMemoriaRam ram using(id_soporteMemoriaRam)
			left join soporteProcesadorModelo pmod using (id_soporteProcesadorModelo)
			left join soporteProcesadorMarca pmar using(id_soporteProcesadorMarca)
			left join soporteProcesadorVelocidad pvel using(id_soporteProcesadorVelocidad)
			left join soporteHdCapacidad hd using(id_soporteHdCapacidad)
			left join soporteUnidadOptica uo using(id_soporteUnidadOptica)
		where t.id_soporteTicketServicioStatus in('2','3')
			and t.id_usuarioAsignado = '" . $_SESSION ["login"]->id_usuario . "'
		order by t.id_soporteTicketServicio	
	";
    $datos = $sql->datosEnArray($query);
    return $datos;
}

// PARAMETROS:
// $fecha_nacimiento - Fecha de nacimiento de una persona.
//
// $fecha_control - Fecha actual o fecha a consultar.
//
//
// EJEMPLO:
// tiempo_transcurrido('22/06/1977', '04/05/2009');
//
function tiempo_transcurrido($fecha_nacimiento, $fecha_control) {
    $fecha_actual = $fecha_control;

    if (!strlen($fecha_actual)) {
        $fecha_actual = date('d/m/Y');
    }

    // separamos en partes las fechas
    $array_nacimiento = explode("/", $fecha_nacimiento);
    $array_actual = explode("/", $fecha_actual);

    $anos = $array_actual [2] - $array_nacimiento [2]; // calculamos a�os
    $meses = $array_actual [1] - $array_nacimiento [1]; // calculamos meses
    $dias = $array_actual [0] - $array_nacimiento [0]; // calculamos d�as
    // ajuste de posible negativo en $d�as
    if ($dias < 0) {
        --$meses;

        // ahora hay que sumar a $dias los dias que tiene el mes anterior de la
        // fecha actual
        switch ($array_actual [1]) {
            case 1 :
                $dias_mes_anterior = 31;
                break;
            case 2 :
                $dias_mes_anterior = 31;
                break;
            case 3 :
                if (bisiesto($array_actual [2])) {
                    $dias_mes_anterior = 29;
                    break;
                } else {
                    $dias_mes_anterior = 28;
                    break;
                }
            case 4 :
                $dias_mes_anterior = 31;
                break;
            case 5 :
                $dias_mes_anterior = 30;
                break;
            case 6 :
                $dias_mes_anterior = 31;
                break;
            case 7 :
                $dias_mes_anterior = 30;
                break;
            case 8 :
                $dias_mes_anterior = 31;
                break;
            case 9 :
                $dias_mes_anterior = 31;
                break;
            case 10 :
                $dias_mes_anterior = 30;
                break;
            case 11 :
                $dias_mes_anterior = 31;
                break;
            case 12 :
                $dias_mes_anterior = 30;
                break;
        }

        $dias = $dias + $dias_mes_anterior;

        if ($dias < 0) {
            --$meses;
            if ($dias == - 1) {
                $dias = 30;
            }
            if ($dias == - 2) {
                $dias = 29;
            }
        }
    }

    // ajuste de posible negativo en $meses
    if ($meses < 0) {
        --$anos;
        $meses = $meses + 12;
    }

    $tiempo [0] = $anos;
    $tiempo [1] = $meses;
    $tiempo [2] = $dias;

    return $tiempo;
}

function bisiesto($anio_actual) {
    $bisiesto = false;
    // probamos si el mes de febrero del a�o actual tiene 29 d�as
    if (checkdate(2, 29, $anio_actual)) {
        $bisiesto = true;
    }
    return $bisiesto;
}

class timerClass {

    var $startTime;
    var $started;

    function timerClass($start = true) {
        $this->started = false;
        if ($start)
            $this->start();
    }

    function start() {
        $startMtime = explode(' ', microtime());
        $this->startTime = (double) ($startMtime [0]) + (double) ($startMtime [1]);
        $this->started = true;
    }

    function end($iterations = 1) {
        $endMtime = explode(' ', microtime());
        if ($this->started) {
            $endTime = (double) ($endMtime [0]) + (double) ($endMtime [1]);
            $dur = $endTime - $this->startTime;
            $avg = 1000 * $dur / $iterations;
            $avg = round(1000 * $avg) / 1000;
            return "$avg milliseconds";
        } else {
            return "timer not started";
        }
    }

}

function obtieneBimestresSecundarias($ciclo, $califican = false) {
    $and = ($califican) ? "and califica like 'S'" : "";

    $sql = new sql ();
    $query_bimestres = "
		select id_escuelaPeriodoEvaluacion, escuelaPeriodoEvaluacion  
		from escuelaPeriodoEvaluacion 
		where id_escuelaArc='2' 
			and id_escuelaCicloEscolar ='" . intval($ciclo) . "' 
			$and
		";

    return $sql->datosEnArray($query_bimestres);
}

function obtieneBimestresPrimarias($ciclo, $califican = false) {

    $and = ($califican) ? "and id_escuelaPeriodoEvaluacion NOT IN ('15','21')" : "";

    $sql = new sql ();
    $query_bimestres = "
		select id_escuelaPeriodoEvaluacion, escuelaPeriodoEvaluacion
		from escuelaPeriodoEvaluacion
		where id_escuelaArc='1'
			and id_escuelaCicloEscolar ='" . intval($ciclo) . "' 
			$and 
		";

    return $sql->datosEnArray($query_bimestres);
}

function obtieneProfesorPorMateriaSecu($escu, $grado) {
    $sql = new sql ();
    $query_materias = "
		select id_escuelaProfesorMateria, id_escuelaTurnosGrupos, id_escuelaPersonalPorEscuela,id_escuelaCurricula, m.escuelaMateria 
		from escuelaProfesorMateria pm join escuelaTurnosGrupos tn using(id_escuelaTurnosGrupos) 
			join escuelaGradoPorPlantel gp using(id_escuelaGradoPorPlantel) 
			join escuelaCurricula c using(id_escuelaCurricula) 
			join escuelaMateria m using(id_escuelaMateria) 
		where gp.id_escuelaPlantel='$escu' 
			and gp.id_escuelaGrado='$grado' 
			and tn.id_escuelaGrupo='1'
		limit 9 
	";
    return $sql->datosEnArray($query_materias);
}

function sincronizaCalificaciones($escuela, $turno) {
    $timer = new timerClass ();
    $timer->start();

    $id_escuelaAlumnoStatusValidos = array(
        1,
        6,
        7
    );

    if ($turno == 1)
        $turnoNum = "100";
    else if ($turno == 2)
        $turnoNum = "200";
    else {
        error("Turno incorrecto ...");
        exit();
    }

    $cct = obtieneUno("escuelaPlantel", "cct", " id_escuelaPlantel='$escuela' ");
    $tabla = $cct . "_" . $turnoNum;

    // DESCOMENTAMOS ESTA VARIABLE PARA QUE SOLO TOME LOS RECIEN SUBIDOS O
    // NUEVOS
    // $nuevos = " and ag.id_escuelaStatusAlumnoGrado='7' ";

    $sql = new sql ();
    $queryAlumnoGrado = "
		select ag.id_escuelaAlumnoGrado, a.curp, ag.id_escuelaAlumnoStatus, ag.prom1, ag.prom2, ag.prom3, gp.id_escuelaGrado
		from escuelaAlumno a join escuelaAlumnoGrado ag using(id_escuelaAlumno) 
			join escuelaTurnosGrupos tn using (id_escuelaTurnosGrupos)
			join escuelaGradoPorPlantel gp using(id_escuelaGradoPorPlantel)
		where gp.id_escuelaPlantel='$escuela'
		and tn.id_escuelaTurno='$turno'
		$nuevos
	";
    $alumnos = $sql->datosEnArray($queryAlumnoGrado);
    // imprime_array($alumnos);
    // exit();

    $bimestres = obtieneBimestresSecundarias();
    // imprime_array($bimestres);

    foreach ($alumnos as $idA => $valorA) {
        // echo "<hr>$valorA[id_escuelaAlumnoGrado] - $valorA[curp] -<hr>";
        // traemos calificaciones de tabla de cliente ligero
        $sql->cierra();

        $calificaciones = traeCalificacionesDeTablaCteLigero($tabla, $valorA ["curp"]);
        $calificaciones = $calificaciones [0];
        // imprime_array($calificaciones);

        require ("../lib/link.php");

        $queryProfMateria = "
			select id_escuelaAlumnoPorMateria, id_escuelaProfesorMateria, id_escuelaCurricula, m.escuelaMateria 
			from escuelaAlumnoPorMateria am join  escuelaProfesorMateria pm using(id_escuelaProfesorMateria)
				join escuelaCurricula c using(id_escuelaCurricula) 
				join escuelaMateria m using(id_escuelaMateria)
			where am.id_escuelaAlumnoGrado='$valorA[id_escuelaAlumnoGrado]' 
		";
        $ProfMateria = $sql->datosEnArray($queryProfMateria);
        // imprime_array($ProfMateria);

        $contMat = 1;
        $calif = array();
        $promFinales = 0;
        $reprobadas = 0;

        foreach ($ProfMateria as $idP => $valorP) {
            $bim = 0;
            $prom = 0;
            $acumula = 0;
            $escuelaAlumnoPromedios = array();

            foreach ($bimestres as $idB => $valorB) {
                $bim = $idB + 1;

                $alumnoCalificaciones = array();

                // verificamos si es BAJA ponemos CEROS de calificaciones

                if (in_array($valorA ["id_escuelaAlumnoStatus"], $id_escuelaAlumnoStatusValidos))
                    $calificacion = $calificaciones ["B" . $bim . "M" . $contMat];
                else
                    $calificacion = 0;

                $alumnoCalificaciones ["id_escuelaPeriodoEvaluacion"] = $bim;
                $alumnoCalificaciones ["id_escuelaAlumnoPorMateria"] = $valorP ["id_escuelaAlumnoPorMateria"];
                $alumnoCalificaciones ["calificacion"] = $calificacion;
                $alumnoCalificaciones ["inasistencias"] = ($bim == 5) ? $calificaciones ["T_I_B" . $contMat] : "0";
                $alumnoCalificaciones ["id_acceso"] = $_SESSION ["login"]->id_acceso;

                // imprime_array($alumnoCalificaciones);
                insertaDatosDirecto("escuelaCalificaciones", $alumnoCalificaciones, false);
                $acumula += $calificaciones ["B" . $bim . "M" . $contMat];
            }

            // verificamos si es BAJA ponemos CERO de promedio

            if (in_array($valorA ["id_escuelaAlumnoStatus"], $id_escuelaAlumnoStatusValidos)) {
                $prom = $acumula / 5;
                $prom = substr($prom, 0, 3);
            } else
                $prom = 0;

            // echo
            // "<hr>[".$valorA[id_escuelaAlumnoGrado]."]".$valorP["id_escuelaCurricula"]."
            // ==> $prom<hr>";

            $escuelaAlumnoPromedios = array(
                "id_escuelaAlumnoGrado" => $valorA ["id_escuelaAlumnoGrado"],
                "id_escuelaCurricula" => $valorP ["id_escuelaCurricula"],
                "calFinal" => $prom,
                "id_acceso" => $_SESSION ["login"]->id_acceso
            );

            // imprime_array($escuelaAlumnoPromedios);

            insertaDatosDirecto("escuelaAlumnoPromedios", $escuelaAlumnoPromedios, false);

            // verificamos si reprobo la materia
            if ($prom < 6)
                $reprobadas ++;

            if ($reprobadas >= 1) // si es irregular no le sacamos promedio, es
            // decir lo ponemos CERO
                $promFinales = 0;
            else
                $promFinales += $prom;

            $contMat ++;
        }

        // Bloque para determinar el StatusAlumnoGrado del alumno
        // /////////////////////////////////////
        $id_statusAlumnoGrado = 0;

        switch ($valorA ["id_escuelaAlumnoStatus"]) {
            case 1 : // ALTA
            case 6 : // INSCRITO
            case 7 : // REPETIDOR
                if ($reprobadas == 0)
                    $id_statusAlumnoGrado = 1; // acreditado
                elseif ($reprobadas <= 5)
                    $id_statusAlumnoGrado = 5; // irregular
                elseif ($reprobadas > 5)
                    $id_statusAlumnoGrado = 9; // Repetidor (reprobado)

                break;

            default :
                $id_statusAlumnoGrado = 8;
                // error("<hr>[".$valorA["id_escuelaAlumnoStatus"]."] ==>
                // id_escuelaAlumnoStatus no encontrado en la bd
                // ...AG[".$valorA["id_escuelaAlumnoGrado"]."]<hr>");
                break;
        }

        $promFinales = $promFinales / 9;
        $promFinales = substr($promFinales, 0, 3);

        $np = false;

        if ($valorA ["id_escuelaGrado"] == 1)
            $grado = 1;
        elseif ($valorA ["id_escuelaGrado"] == 2) {
            $grado = 2;
            // if ($valorA["prom1"] == 0.0)
            // $np = true;
        } elseif ($valorA ["id_escuelaGrado"] == 3) {
            $grado = 3;
            // if ($valorA["prom1"] == 0.0 || $valorA["prom2"] == 0.0)
            // $np = true;
        }

        // if ($np)
        // $id_statusAlumnoGrado = 2;
        // Calculamos el promedio general en caso de 3ros.

        $promGral = 0;
        if ($valorA ["id_escuelaGrado"] == 3 && $id_statusAlumnoGrado == 1) {
            // aqui entran solo los acreditados de 3ro, es decir, ninguna
            // reprobada y promedio >= 6

            if ($valorA ["prom1"] == 0.0 || $valorA ["prom2"] == 0.0) {
                $id_statusAlumnoGrado = 2;
                $promGral = 0.0;
            } else {
                $promGral1 = ($valorA ["prom1"] + $valorA ["prom2"] + $promFinales) / 3;
                // if (!$np)
                $promGral = substr($promGral1, 0, 3);
                // else
                // $promGral = 0.0;
            }
        }

        $alumnoGradoUpgrade = array(
            "prom$grado" => $promFinales,
            "id_escuelaStatusAlumnoGrado" => $id_statusAlumnoGrado,
            "promGral" => $promGral
        );

        actualizaDatos("escuelaAlumnoGrado", $alumnoGradoUpgrade, " id_escuelaAlumnoGrado='" . $valorA ["id_escuelaAlumnoGrado"] . "' ");
        // actualizaDatos("escuelaAlumnoGrado", array( "prom$grado"=>
        // $promFinales), " id_escuelaAlumnoGrado='$valorA[id_escuelaAlumnoGrado]'
        // ");
        // actualizaDatos("escuelaAlumnoGrado",
        // array("id_escuelaStatusAlumnoGrado" => $id_statusAlumnoGrado), "
        // id_escuelaAlumnoGrado='".$valorA["id_escuelaAlumnoGrado"]."' ");
        // actualizaDatos("escuelaAlumnoGrado", array( "promGral"=> $promGral),
        // " id_escuelaAlumnoGrado='$valorA[id_escuelaAlumnoGrado]' ");
        // echo "<hr>Promedio Grado[".$valorA[id_escuelaAlumnoGrado]."] =
        // ".$promFinales." ---- Reprobadas: $reprobadas --- StatusAlumnoGrado:
        // $id_statusAlumnoGrado <hr>";
        // exit();
    }
    $endexct = ($timer->end() / 1000) / 60;
    error("<hr>Calificaciones sincronizadas correctamente, tiempo: " . $endexct . " minutos <hr>");
}

function traeCalificacionesDeTablaCteLigero($tabla, $curp) {
    require ("../lib/link2.php");
    $_SESSION ["link"] = $link2;
    $sql = new sql ();

    $listado = $sql->datosEnArray("
		select CURP,
			B1M1, B1M2, B1M3, B1M4, B1M5, B1M6, B1M7, B1M8, B1M9,
			B2M1, B2M2, B2M3, B2M4, B2M5, B2M6, B2M7, B2M8, B2M9,
			B3M1, B3M2, B3M3, B3M4, B3M5, B3M6, B3M7, B3M8, B3M9,
			B4M1, B4M2, B4M3, B4M4, B4M5, B4M6, B4M7, B4M8, B4M9,
			B5M1, B5M2, B5M3, B5M4, B5M5, B5M6, B5M7, B5M8, B5M9,
			T_I_B1, T_I_B2, T_I_B3, T_I_B4, T_I_B5
		from $tabla
		where CURP='$curp'
	");
    $link2->close();
    return $listado;
}

function obtieneGradosDeEscuela($escu) {
    $sql = new sql ();
    $grados = array();
    $query = "
		select id_escuelaGrado from escuelaGradoPorPlantel where id_escuelaPlantel='$escu'
	";
    $temp = $sql->datosEnArray($query);

    if (!empty($temp) && count($temp) != 0) {
        foreach ($temp as $valor)
            $grados [] = $valor ["id_escuelaGrado"];
    }
    return $grados;
}

function listaEscuelasSubidasDeDbf() {
    $sql = new sql ();
    $query = "
		select ep.id_escuelaPlantel, ep.nombre, ep.cct, et.escuelaTurno, et.id_escuelaTurno
		from escuelaAlumnoGrado ag join escuelaTurnosGrupos tg using(id_escuelaTurnosGrupos)
			join escuelaTurno et using(id_escuelaTurno)
			join escuelaGradoPorPlantel gpp using(id_escuelaGradoPorPlantel)
			join escuelaPlantel ep using(id_escuelaPlantel)
		where id_escuelaPlantel > '302'
		group by ep.cct, et.id_escuelaTurno
	";
    $datos = $sql->datosEnArray($query);
    return $datos;
}

function obtieneNumEscuelasSubidas() {
    $sql = new sql ();
    $query = "
		select distinct(ep.id_escuelaPlantel) 
		from escuelaPlantel ep join escuelaGradoPorPlantel gpp using(id_escuelaPlantel)
			join escuelaTurnosGrupos etg using(id_escuelaGradoPorPlantel)
			join escuelaAlumnoGrado eag using(id_escuelaTurnosGrupos)
	";
    $sql->runQuery($query);
    return $sql->rows();
}

function obtieneTotalEscuelas() {
    $sql = new sql ();
    $sql->runQuery("select id_escuelaPlantel from escuelaPlantel");
    return $sql->rows();
}

function obtieneAlumnosSubidos($escu, $turno) {
    $sql = new sql ();
    $query = "
		select count(eag.id_escuelaAlumnoGrado) as total, tg.id_escuelaTurnosGrupos, escuelaTurno, ega.id_escuelaGrado, eg.escuelaGrupo
		from escuelaAlumnoGrado eag join escuelaTurnosGrupos tg using(id_escuelaTurnosGrupos) 
			join escuelaTurno et using(id_escuelaTurno)
			join escuelaGrupo eg using(id_escuelaGrupo)
			join escuelaGradoPorPlantel egpp using(id_escuelaGradoPorPlantel) 
			join escuelaGrado ega using(id_escuelaGrado)
		where egpp.id_escuelaPlantel = '$escu'
			and tg.id_escuelaTurno IN ($turno)
		group by et.id_escuelaTurno, ega.id_escuelaGrado, eg.id_escuelaGrupo
	";
    return $sql->datosEnArray($query);
}

function edad($edad) {
    list ( $Y, $m, $d ) = explode("-", $edad);
    // return( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );

    $meses = (9 - $m < 0) ? 9 - $m + 12 : 9 - $m;
    $res = array(
        (901 < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y),
        $meses
    );
    return $res;
}

function obtieneAlumnos($idEscuela, $inStatusGrado = "", $grado = "", $turno = "", $grupo = "", $ciclo = "", $inAlumnoStatus = "") {
    $and = "";
    if (!empty($inStatusGrado) || $inStatusGrado != 0) {
        $and = " and ag.id_escuelaStatusAlumnoGrado IN($inStatusGrado) ";
    }

    $andAlumnoStatus = "";
    if (!empty($inAlumnoStatus) || $inAlumnoStatus != 0) {
        $andAlumnoStatus = " and ag.id_escuelaAlumnoStatus IN($inAlumnoStatus) ";
    }

    $andGrado = "";
    if (!empty($grado) || $grado != 0) {
        $andGrado = " and g.id_escuelaGrado IN ($grado) ";
    }

    $andTurno = "";
    if (!empty($turno) || $turno != 0) {
        $andTurno = " and tg.id_escuelaTurno='$turno' ";
    }

    $andGrupo = "";
    if (!empty($grupo) || $grupo != 0) {
        $andGrupo = " and gpo.id_escuelaGrupo = '$grupo'";
    }

    $andCiclo = "";
    if (!empty($ciclo) || $ciclo != 0)
        $andCiclo = " and ece.vigente = '$ciclo'";
    else
        $andCiclo = " and ece.vigente like 'S'";

    $sql = new sql ();
    $query = "
		select ag.*, a.*, p.nombre as escuela, p.cct, t.escuelaTurno, g.id_escuelaGrado, g.escuelaGrado, gpo.escuelaGrupo, gpp.*, sag.clave
		from escuelaAlumno a join escuelaAlumnoGrado ag using(id_escuelaAlumno)
			join escuelaStatusAlumnoGrado sag using(id_escuelaStatusAlumnoGrado)
			join escuelaTurnosGrupos tg using(id_escuelaTurnosGrupos)
			join escuelaGradoPorPlantel gpp using(id_escuelaGradoPorPlantel)
			join escuelaPrograma epro using (id_escuelaPrograma)
			join escuelaCicloEscolar ece using (id_escuelaCicloEscolar)
			join escuelaTurno t using (id_escuelaTurno)
			join escuelaGrado g using (id_escuelaGrado)
			join escuelaGrupo gpo using (id_escuelaGrupo)
			join escuelaPlantel p using(id_escuelaPlantel)
		where gpp.id_escuelaPlantel='$idEscuela'
			$and $andGrado $andTurno $andGrupo $andCiclo
			$andAlumnoStatus
		order by id_escuelaTurno, g.id_escuelaGrado, id_escuelaGrupo, app, apm, nombre
	";
    return $sql->datosEnArray($query);
}

function obtienePromediosAlumno($idAg) {
    $sql = new sql ();
    $query = "
	select ep.*, ec.id_escuelaMateria, m.escuelaMateria 
	from escuelaAlumnoPromedios ep join escuelaCurricula ec using(id_escuelaCurricula)
		join escuelaMateria m using (id_escuelaMateria)
	where ep.id_escuelaAlumnoGrado='$idAg'
	order by ec.ordenImpresion
	";
    return $sql->datosEnArray($query);
}

function moduloNoTienePermiso() {
    error("<hr><br>No tiene permiso para este modulo<br><br><hr>");
}

function esAnalistaB() {
    $sql = new sql ();
    $query = "
		select ea.id_escuelaAnalista 
		from escuelaAnalista ea join  usuario u using(id_usuario)
			join escuelaUnidadAdmva ua using(id_escuelaUnidadAdmva)
		where u.id_usuario='" . $_SESSION ["login"]->id_usuario . "'
			 and ua.id_escuelaArc in ('2','3')
	";
    $res = $sql->datosEnArray($query);

    return (count($res) >= 1) ? true : false;
}

function esAnalistaA() {
    $sql = new sql ();
    $query = "
		select ea.id_escuelaAnalista
		from escuelaAnalista ea join  usuario u using(id_usuario)
			join escuelaUnidadAdmva ua using(id_escuelaUnidadAdmva)
		where u.id_usuario='" . $_SESSION ["login"]->id_usuario . "'
			 and ua.id_escuelaArc='1'
	";
    $res = $sql->datosEnArray($query);

    return (count($res) >= 1) ? true : false;
}

function esAnalistaC() {
    $sql = new sql ();
    $query = "
		select ea.id_escuelaAnalista
		from escuelaAnalista ea join  usuario u using(id_usuario)
			join escuelaUnidadAdmva ua using(id_escuelaUnidadAdmva)
		where u.id_usuario='" . $_SESSION ["login"]->id_usuario . "'
			 and ua.id_escuelaArc='3'
	";
    $res = $sql->datosEnArray($query);

    return (count($res) >= 1) ? true : false;
}

function obtieneTurnosEscuela($escu, $ciclo) {
    $sql = new sql ();
    $query = "
		select distinct(t.id_escuelaTurno), t.escuelaTurno
		from escuelaTurnosGrupos etg join escuelaTurno t using(id_escuelaTurno)
			join escuelaGradoPorPlantel gpp using(id_escuelaGradoPorPlantel)
			join escuelaPrograma ep using(id_escuelaPrograma)
		where gpp.id_escuelaPlantel='" . intval($escu) . "'
			and ep.id_escuelaCicloEscolar='" . intval($ciclo) . "'
		order by t.id_escuelaTurno
	";
    return $res = $sql->datosEnArray($query);
}

function verificaMateriaEstaRegularizadaDeAlumno($ag, $curricula, $periodoLimite = 0) {
    $sql = new sql ();

    if (intval($periodoLimite) > 0)
        $and = " and id_escuelaPeriodoRegularizacion <= '$periodoLimite' ";

    $queryHistorial = "
		select id_escuelaAlumnoRegularizacion, calificacion
		from escuelaAlumnoRegularizacion
		where id_escuelaAlumnoGrado='$ag'
			and id_escuelaCurricula='$curricula'
			$and
		order by id_escuelaPeriodoRegularizacion DESC
	";
    return $sql->datosEnArray($queryHistorial);
}

function regularizaAlumno($post, $regularizacion) {
    $sql = new sql ();
// 	echo "<hr> $post[grado] A regularizar => ". $_POST["materias"] ."<hr>";
// 	exit();

    $promedios = obtienePromediosAlumno($_POST ["ag"]);

    // calculamos promedio del grado con nueva calificacion
    $p = 0;
    $irregular = false;
    $calificacion = 0;

// 	imprime_array($_POST);
// 	imprime_array($promedios);
// 	exit();

    foreach ($promedios as $idP => $valorP) {
        if ($_POST ["materias"] == $valorP ["id_escuelaCurricula"]) {
            // ES LA MATERIA QUE SE ESTA REGULARIZANDO
// 			echo "<hr>[R] $valorP[id_escuelaCurricula] ==> EN BD
// 			[$valorP[calFinal]] NUEVA ===>$_POST[calificacion]<hr>";

            $existe = verificaMateriaEstaRegularizadaDeAlumno($valorP [id_escuelaAlumnoGrado], $valorP [id_escuelaCurricula]);

            // imprime_array($existe);
            // exit();

            if (count($existe) > 0 && $existe [0] ["calificacion"] >= 6) {
                error("ERROR !!!. La materia que intenta regularizar ya esta regularizada");
                exit();
            }

            if ($valorP ["calFinal"] >= 6) {
                error("ERROR !!!. La materia que intenta regularizar no tiene promedio reprobatorio");
                exit();
            }

            $calificacion = $_POST ["calificacion"];
        } else {
            // BUSCAMOS SI ESTA MATERIA HA TENIDO REGULARIZACIONES PA TOMAR LA
            // ULTIMA CALIFICACION DE REGULARIZACION PARA CALCULAR PROMEDIO

            $existe = verificaMateriaEstaRegularizadaDeAlumno($valorP [id_escuelaAlumnoGrado], $valorP [id_escuelaCurricula]);

// 			imprime_array($existe);
// 			exit();

            if (count($existe) > 0) {
                $califRegularizadaAnterior = $existe [0] ["calificacion"];
                // echo "<hr>Ya se ha regularizado, ultima calificacion:
                // [$valorP[id_escuelaCurricula]] =>
                // $califRegularizadaAnterior<hr>";

                $calificacion = $califRegularizadaAnterior;
            } else {
                // NO HA TENIDO REGULARIZACIONES, SE TOMA LA CALIFICACION
                // ORIGINAL
                // echo "<hr>$valorP[id_escuelaCurricula] ==>
                // $valorP[calFinal]<hr>";
                $calificacion = $valorP ["calFinal"];
            }
        }

        $p += $calificacion;

        // verificamos si aun tiene calificaciones reprobadas
        if ($calificacion < 6)
            $irregular = true;
    }

// 	exit();

    if (!$irregular) {
        $prom = $p / 9;
        $prom3 = substr($prom, 0, 3);
// 		echo "<hr>Promedio de Grado: $prom3 <hr>";
// 		echo "prom".$post["grado"];

        $actualizaAg = array();
        $actualizaAg ["id_escuelaPeriodoRegularizacion"] = $post["periodo"];
        $idA = obtieneUno("escuelaAlumnoGrado", "id_escuelaAlumno", "id_escuelaAlumnoGrado = '$_POST[ag]'");

        if ($post ["grado"] == 3) {

            // verificamos promedios anteriores
            $promAnteriores = $sql->datosEnArray("
					select sprom1, sprom2 from escuelaAlumno where id_escuelaAlumno='$idA'
				");
            $promAnteriores = $promAnteriores [0];

            $actualizaAg ["sprom3"] = $prom3;

// 			imprime_array($promAnteriores);
// 			exit();

            if ($promAnteriores ["sprom1"] == "0.0" || $promAnteriores ["sprom2"] == "0.0") {
                // IRREGULAR, LE FALTAN PROMEDIOS DE A�OS ANTERIORES
                $actualizaAg ["id_escuelaStatusAlumnoGrado"] = 5;
            } else {
                // PROMOVIDO. TODOS LOS PROMEDIOS COMPLETOS
                $promGralTemp = ($promAnteriores ["sprom1"] + $promAnteriores ["sprom2"] + $prom3) / 3;
                $promGral = substr($promGralTemp, 0, 3);

                if ($promGral >= 6) {

                    // promedio general de secundaria aprobatorio
                    // verificamos promedio de primaria
                    $pPrim = obtieneUno("escuelaAlumno", "pPromGral", "id_escuelaAlumno='$idA'");

                    if ($pPrim > 5 || $pPrim == "1.0") {

                        // calculamos promedio de basica

                        $pBasica = ($pPrim == 1.0) ? $promGral : ($pPrim + $promGral) / 2;
                        $pBasica = substr($pBasica, 0, 3);
                        $actualizaAg["promBasica"] = $pBasica;

                        $actualizaAg ["sPromGral"] = $promGral;
                        $actualizaAg ["id_escuelaStatusAlumnoGrado"] = 10; // PROMOVIDO, PENDIENTE REVISION
                        // sacamos folio de certificado
// 						$next	= obtieneSiguienteCertificado();
// 						$actualizaAg ["basicaFolioCertificado"] = "A $next";
                    }
                }
            }
        } else {
            $actualizaAg ["sprom" . $post ["grado"]] = $prom3;
            $actualizaAg ["id_escuelaStatusAlumnoGrado"] = 1; // Acreditado			
        }

// 		imprime_array($actualizaAg);
// 		exit();
        // actualizamos promedio y status
        actualizaDatos("escuelaAlumno", $actualizaAg, " id_escuelaAlumno='$idA' ");
        actualizaDatos("escuelaAlumnoGrado", $actualizaAg, " id_escuelaAlumnoGrado='$_POST[ag]' ");
    } else {
        // echo "<hr>Alumno sigue IRREGULAR ... no se actualiza promedio de
        // grado ni general ... <hr>";
    }

// 	imprime_array($regularizacion);
// 	exit();

    insertaDatosDirecto("escuelaAlumnoRegularizacion", $regularizacion, false);

    return "regOk";
}

function obtieneSiguienteCertificado() {
    $sql = new sql();
    $max = $sql->datosEnArray("SELECT MAX( SUBSTRING( basicaFolioCertificado, 3, 7 ) ) AS folio FROM escuelaAlumno");
    return $max [0] ["folio"] + 1;
}

function obtieneRegularizacionesReprobadasDeAlumno($ag, $grado) {
    $sql = new sql ();
    $query = "
		select ar.* 
		from escuelaAlumnoRegularizacion ar join escuelaCurricula ec using(id_escuelaCurricula) 
		where ar.id_escuelaAlumnoGrado='" . intval($ag) . "'
			and ec.id_escuelaGrado='" . intval($grado) . "'
			and ar.calificacion < '6'
	";
    return $res = $sql->datosEnArray($query);
}

function obtieneGradosGruposPorTurnoPorEscuela($escu, $turno, $ciclo, $grado = 0) {
    $gdo = (intval($grado) == 0) ? "" : " and g.id_escuelaGrado='" . intval($grado) . "'";

    $sql = new sql ();
    $query = "
		select tg.id_escuelaTurnosGrupos, g.id_escuelaGrado, g.escuelaGrado, eg.escuelaGrupo, tg.id_escuelaTurno
		from  escuelaGradoPorPlantel gpp join  escuelaGrado g using(id_escuelaGrado)
			join escuelaPrograma epro using (id_escuelaPrograma)
			join escuelaTurnosGrupos tg using(id_escuelaGradoPorPlantel)
			join escuelaGrupo eg using(id_escuelaGrupo)
		where gpp.id_escuelaPlantel='$escu'
			and tg.id_escuelaTurno='$turno'
			and epro.id_escuelaCicloEscolar='$ciclo'
			$gdo
	";
    return $res = $sql->datosEnArray($query);
}

function obtieneTotalAlumnosPorStatus($escu = 0, $turno = 0, $grado = 0, $grupo, $status) {
    $sql = new sql ();
    $query = "
		select count(a.id_escuelaAlumno) as total
		from escuelaAlumno a join escuelaAlumnoGrado ag using(id_escuelaAlumno)
		join escuelaTurnosGrupos etg using(id_escuelaTurnosGrupos)
		where etg.id_escuelaTurnosGrupos ='$grupo'
			and ag.id_escuelaAlumnoStatus IN ($status)
	";
    $res = $sql->datosEnArray($query);
    return $res [0] ["total"];
}

function obtieneTotalAlumnosReprobados($escu = 0, $turno = 0, $grado = 0, $grupo) {
    $sql = new sql ();
    $query = "
		select count(a.id_escuelaAlumno) as total
		from escuelaAlumno a join escuelaAlumnoGrado ag using(id_escuelaAlumno)
		join escuelaTurnosGrupos etg using(id_escuelaTurnosGrupos)
		where etg.id_escuelaTurnosGrupos ='$grupo'
			and ag.id_escuelaStatusAlumnoGrado IN ('9')
	";
    $res = $sql->datosEnArray($query);
    return $res [0] ["total"];
}

function obtieneCiclosEscolares() {
    $sql = new sql ();
    $query = "
		select *
		from escuelaCicloEscolar
	";
    $res = $sql->datosEnArray($query);
    return $res;
}

function obtieneEstadisticaPorEscuela($escu) {

    $ciclos = obtieneCiclosEscolares();

    foreach ($ciclos as $idC => $valorC) {
        echo "<div align='center'>";
        error("<hr><strong>CICLO ESCOLAR: $valorC[escuelaCicloEscolar]</strong><br><hr><br>");
        echo "</div>";

        $turnos = obtieneTurnosEscuela($_POST["escu"], $valorC["id_escuelaCicloEscolar"]);

        $sql = new sql ();

        $alumnoStatus = $sql->datosEnArray("select * from escuelaAlumnoStatus");

        foreach ($turnos as $idT => $valorT) {

            $grados = obtieneGradosGruposPorTurnoPorEscuela($escu, $valorT ["id_escuelaTurno"], $valorC["id_escuelaCicloEscolar"]);
            echo "<table align='center' id='Listado' class='tablaListado' cellpadding='3' >";
            echo "<tr>";
            echo "<td><strong>$valorT[escuelaTurno]</strong></td>";
            foreach ($grados as $idG => $valorG) {
                echo "<td>$valorG[escuelaGrado] - $valorG[escuelaGrupo]<br> [" . $valorG["id_escuelaTurnosGrupos"] . "] </td>";
            }
            echo "</tr>";

            foreach ($alumnoStatus as $idA => $valorA) {
                echo "<tr>";
                echo "<td>$valorA[escuelaAlumnoStatus]</td>";
                foreach ($grados as $idG => $valorG) {
                    echo "<td align='center'>";
                    echo obtieneTotalAlumnosPorStatus(0, 0, 0, $valorG ["id_escuelaTurnosGrupos"], $valorA ["id_escuelaAlumnoStatus"]);
                    echo "</td>";
                }
                echo "</tr>";
            }

            echo "<tr>";
            echo "<td>REPROBADOS</td>";
            foreach ($grados as $idG => $valorG) {
                echo "<td align='center'>";
                echo obtieneTotalAlumnosReprobados(0, 0, 0, $valorG ["id_escuelaTurnosGrupos"]);
                echo "</td>";
            }
            echo "</tr>";

            echo "</table>
			<bR><br>
			";
            // imprime_array($grados);
        }
    }
}

function obtieneMaterias($escu, $grado, $ciclo = 0) {
    $sql = new sql ();
    $whereCiclo = ($ciclo == 0) ? "eci.vigente like 'S'" : "eci.id_escuelaCicloEscolar='$ciclo'";

    $query = "
	select id_escuelaProfesorMateria, id_escuelaTurnosGrupos, id_escuelaPersonalPorEscuela,
	id_escuelaCurricula, m.id_escuelaMateria, m.escuelaMateria, c.ordenImpresion
	from escuelaProfesorMateria pm join escuelaTurnosGrupos tn using(id_escuelaTurnosGrupos) 
		join escuelaGradoPorPlantel gp using(id_escuelaGradoPorPlantel) 
		join escuelaCurricula c using(id_escuelaCurricula) 
		join escuelaMateria m using(id_escuelaMateria)
		join escuelaPrograma eprog on (eprog.id_escuelaPrograma = c.id_escuelaPrograma)
		join escuelaCicloEscolar eci using(id_escuelaCicloEscolar) 
	where gp.id_escuelaPlantel='$escu' 
		and gp.id_escuelaGrado='$grado'
		and $whereCiclo
	group by c.id_escuelaCurricula
	order by c.ordenImpresion
	";

    return $sql->datosEnArray($query);
}

function obtieneMateriasPorTurnoGradoGrupo($escuela, $turno, $grado, $grupo) {
    $sql = new sql ();
    $query = "
			select c.*, m.escuelaMateria, etg.id_escuelaTurnosGrupos, epm.id_escuelaProfesorMateria
			from escuelaCurricula c join escuelaMateria m using (id_escuelaMateria)
				join escuelaGrado eg on (eg.id_escuelaGrado = c.id_escuelaGrado)
				join escuelaPrograma ep on (ep.id_escuelaPrograma = c.id_escuelaPrograma)
				join escuelaCicloEscolar ce using (id_escuelaCicloEscolar)
				join escuelaGradoPorPlantel gpp on (gpp.id_escuelaPrograma = ep.id_escuelaPrograma)
				join escuelaTurnosGrupos etg on (etg.id_escuelaGradoPorPlantel = gpp.id_escuelaGradoPorPlantel)
				join escuelaProfesorMateria epm on (epm.id_escuelaCurricula = c.id_escuelaCurricula)
			where gpp.id_escuelaPlantel='" . intval($escuela) . "'
				and c.id_escuelaGrado='" . intval($grado) . "'
				and ce.vigente like 'S'
				and gpp.id_escuelaGrado='" . $grado . "'
				and etg.id_escuelaTurno='" . $turno . "'
				and etg.id_escuelaGrupo='" . $grupo . "'
				and epm.vigente like 'S'
				and epm.id_escuelaTurnosGrupos = (
				select a.id_escuelaTurnosGrupos
				from escuelaTurnosGrupos a join escuelaGradoPorPlantel b using (id_escuelaGradoPorPlantel)
				join escuelaPrograma c using (id_escuelaPrograma)
				join escuelaCicloEscolar d using (id_escuelaCicloEscolar)
				where b.id_escuelaGrado='$grado'
				and a.id_escuelaTurno='$turno'
				and a.id_escuelaGrupo='$grupo'
				and b.id_escuelaPlantel='" . $escuela . "'
    						and d.vigente  like 'S'
					)
			order by c.ordenImpresion
			";
    return $sql->datosEnArray($query);
}

function obtieneMateriasPorAlumno($idAg, $bloque) {
    $ciclo = obtieneCicloEscolarVigente();
    $sql = new sql ();

    $query = "
		select em.escuelaMateria, ecu.id_escuelaCurricula, epm.id_escuelaProfesorMateria, concat (ea.app,' ',ea.apm,' ',ea.nombre) as alumno
		from escuelaMateria em join escuelaCurricula ecu using (id_escuelaMateria)
			join escuelaProfesorMateria epm using (id_escuelaCurricula)
			join escuelaPersonalPorEscuela epesc using (id_escuelaPersonalPorEscuela)
			join escuelaPrograma ep on (ep.id_escuelaPrograma = ecu.id_escuelaPrograma)
			join escuelaCicloEscolar ece using (id_escuelaCicloEscolar)
			join escuelaGradoPorPlantel egpp on (ep.id_escuelaPrograma = egpp.id_escuelaPrograma)
			join escuelaTurnosGrupos etg using (id_escuelaGradoPorPlantel)
			join escuelaAlumnoGrado ag on (ag.id_escuelaTurnosGrupos = etg.id_escuelaTurnosGrupos)
			join escuelaAlumno ea using (id_escuelaAlumno)
		where etg.id_escuelaTurnosGrupos = (
					select id_escuelaturnosGrupos 
					from escuelaAlumnoGrado join escuelaTurnosGrupos using (id_escuelaTurnosGrupos)
						join escuelaGradoPorPlantel using (id_escuelaGradoPorPlantel)
						join escuelaPrograma using (id_escuelaPrograma)
					where id_escuelaAlumnoGrado='$idAg'
						and id_escuelaCicloEscolar='$ciclo'
						and id_escuelaAlumnoStatus in (1,6,7,11,14,18)
					)
			and ece.vigente like 'S'
			and epm.id_escuelaTurnosGrupos = (
					select id_escuelaturnosGrupos 
					from escuelaAlumnoGrado join escuelaTurnosGrupos using (id_escuelaTurnosGrupos)
						join escuelaGradoPorPlantel using (id_escuelaGradoPorPlantel)
						join escuelaPrograma using (id_escuelaPrograma)
					where id_escuelaAlumnoGrado='$idAg'
						and id_escuelaCicloEscolar='$ciclo'
						and id_escuelaAlumnoStatus in (1,6,7,11,14,18)
					)
			and ag.id_escuelaAlumnoGrado='$idAg'
			and epesc.id_escuelaStatusPersonal='1'
			and epm.vigente like 'S'
		order by ecu.ordenImpresion
	";

    return $sql->datosEnArray($query);
}

function obtieneListadoAlumnosRna() {
    $sql = new sql ();

    $query = "
	select 
		ea.id_escuelaAlumno,
		ag.id_escuelaAlumnoGrado, ea.curp as CURP, ea.app as Primer_apellido, ea.apm as Segundo_apellido, ea.nombre as Nombre,
		CASE ea.id_sexo WHEN 1 THEN 'H' WHEN 2 THEN 'M' ELSE 'X' END as Genero, 
		DATE_FORMAT(ea.fechaNac,'%d/%m/%Y') as Fecha_nac, e.clave as Ent_nac,
		ep.cct as CCT, et.escuelaTurno as Turno, egra.id_escuelaGrado, egra.escuelaGrado as Grado, egpo.escuelaGrupo as Grupo,
		esgd.id_escuelaStatusAlumnoGrado as Situacion, ea.basicaFolioCertificado as Folio_doc, ag.id_escuelaPeriodoRegularizacion,
		sprom1, sprom2, sprom3, sPromGral as Promedio_gral, ep.nombre as escuela, ece.escuelaCicloEscolar
	from escuelaAlumno ea join escuelaAlumnoGrado ag using(id_escuelaAlumno)
		join escuelaStatusAlumnoGrado esgd using(id_escuelaStatusAlumnoGrado)
		join estado e using(id_estado)
		join escuelaTurnosGrupos etg using(id_escuelaTurnosGrupos)
		join escuelaTurno et using(id_escuelaTurno)
		join escuelaGrupo egpo using(id_escuelaGrupo)
		join escuelaGradoPorPlantel egpp using(id_escuelaGradoPorPlantel)
		join escuelaPrograma epro using (id_escuelaPrograma)
		join escuelaCicloEscolar ece using (id_escuelaCicloEscolar)
		join escuelaGrado egra using(id_escuelaGrado)
		join escuelaPlantel ep using(id_escuelaPlantel)
	where id_escuelaStatusAlumnoGrado IN ('1','2','3','5','9')
		and epro.id_escuelaCicloEscolar='2'
		and ep.id_escuelaPlantel IN ('129','153','261')
	order by ep.cct, et.id_escuelaTurno, egra.id_escuelaGrado, egpo.id_escuelaGrupo, ea.curp
	";

    return $sql->datosEnArray($query);
}

function obtieneListadoAlumnosRodac() {
    $sql = new sql ();

    $query = "
	select
		ea.id_escuelaAlumno,
		ag.id_escuelaAlumnoGrado, ea.curp as CURP, ea.app as Primer_apellido, ea.apm as Segundo_apellido, ea.nombre as Nombre,
		CASE ea.id_sexo WHEN 1 THEN 'H' WHEN 2 THEN 'M' ELSE 'X' END as Genero,
		DATE_FORMAT(ea.fechaNac,'%d/%m/%Y') as Fecha_nac, e.clave as Ent_nac,
		ep.cct as CCT, et.id_escuelaTurno as Turno, egra.id_escuelaGrado, egra.escuelaGrado as Grado, egpo.escuelaGrupo as Grupo,
		esgd.id_escuelaStatusAlumnoGrado, ea.basicaFolioRodac, ea.basicaFolioCertificado, ea.pPromGral, ea.sPromGral, ea.promBasica
	from escuelaAlumno ea join escuelaAlumnoGrado ag using(id_escuelaAlumno)
		join escuelaStatusAlumnoGrado esgd using(id_escuelaStatusAlumnoGrado)
		join estado e using(id_estado)
		join escuelaTurnosGrupos etg using(id_escuelaTurnosGrupos)
		join escuelaTurno et using(id_escuelaTurno)
		join escuelaGrupo egpo using(id_escuelaGrupo)
		join escuelaGradoPorPlantel egpp using(id_escuelaGradoPorPlantel)
		join escuelaPrograma epro using (id_escuelaPrograma)
		join escuelaGrado egra using(id_escuelaGrado)
		join escuelaPlantel ep using(id_escuelaPlantel)
	where id_escuelaStatusAlumnoGrado IN ('3')
		and epro.id_escuelaCicloEscolar='2'
		and ag.id_escuelaAlumnoStatus IN('1','2','3','5','6','7','11','14')
	order by ep.cct, et.id_escuelaTurno, egra.id_escuelaGrado, egpo.id_escuelaGrupo, ea.curp
	";

    return $sql->datosEnArray($query);
}

function obtieneListadoInicioDeCiclo() {
    $sql = new sql();

    $query = "
	select 
		ea.id_escuelaAlumno, ag.id_escuelaAlumnoGrado, ea.curp as CURP, ea.app as Primer_apellido, ea.apm as Segundo_apellido, ea.nombre as Nombre, ag.id_escuelaAlumnoStatus as Situacion,
		CASE ea.id_sexo WHEN 1 THEN 'H' WHEN 2 THEN 'M' ELSE 'X' END as Genero, l.CVE_ENT, pai.pais, ep.id_escuelaTipoEscuela, 
		DATE_FORMAT(ea.fechaNac,'%d/%m/%Y') as Fecha_nac, e.clave as Ent_nac,
		ep.cct as CCT, et.id_escuelaTurno as Turno, egra.id_escuelaGrado, egra.escuelaGrado as Grado, egpo.escuelaGrupo as Grupo		
	from escuelaAlumno ea join escuelaAlumnoGrado ag using(id_escuelaAlumno)
		join escuelaStatusAlumnoGrado esgd using(id_escuelaStatusAlumnoGrado)
		join estado e on (e.id_estado = ea.id_estado)
		join pais pai on (pai.id_pais = e.id_pais)
		join escuelaTurnosGrupos etg using(id_escuelaTurnosGrupos)
		join escuelaTurno et using(id_escuelaTurno)
		join escuelaGrupo egpo using(id_escuelaGrupo)
		join escuelaGradoPorPlantel egpp using(id_escuelaGradoPorPlantel)
		join escuelaPrograma eprog using(id_escuelaPrograma)
		join escuelaCicloEscolar ec using(id_escuelaCicloEscolar)
		join escuelaGrado egra using(id_escuelaGrado)
		join escuelaPlantel ep using(id_escuelaPlantel)
		join localidad l on (l.id_localidad = ag.id_localidad)		
	where id_escuelaAlumnoStatus IN ('1','6','7','11')
		and ec.vigente like 'S'	
		and ep.id_escuelaTipoEscuela IN (6,9,10)
	order by ep.cct, et.id_escuelaTurno, egra.id_escuelaGrado, egpo.id_escuelaGrupo, ea.curp
	";
    return $sql->datosEnArray($query);
}

function obtieneListadoInicioDeCicloPreescolar() {
    $sql = new sql();

    $query = "
	select
		ea.id_escuelaAlumno, ag.id_escuelaAlumnoGrado, ea.curp as CURP, ea.app as Primer_apellido, ea.apm as Segundo_apellido, ea.nombre as Nombre, ag.id_escuelaAlumnoStatus as Situacion,
		CASE ea.id_sexo WHEN 1 THEN 'H' WHEN 2 THEN 'M' ELSE 'X' END as Genero, l.CVE_ENT, pai.pais, ep.id_escuelaTipoEscuela,
		DATE_FORMAT(ea.fechaNac,'%d/%m/%Y') as Fecha_nac, e.clave as Ent_nac,
		ep.cct as CCT, et.id_escuelaTurno as Turno, egra.id_escuelaGrado, egra.escuelaGrado as Grado, egpo.escuelaGrupo as Grupo
	from escuelaAlumno ea join escuelaAlumnoGrado ag using(id_escuelaAlumno)
		join escuelaStatusAlumnoGrado esgd using(id_escuelaStatusAlumnoGrado)
		join estado e on (e.id_estado = ea.id_estado)
		join pais pai on (pai.id_pais = e.id_pais)
		join escuelaTurnosGrupos etg using(id_escuelaTurnosGrupos)
		join escuelaTurno et using(id_escuelaTurno)
		join escuelaGrupo egpo using(id_escuelaGrupo)
		join escuelaGradoPorPlantel egpp using(id_escuelaGradoPorPlantel)
		join escuelaPrograma eprog using(id_escuelaPrograma)
		join escuelaCicloEscolar ec using(id_escuelaCicloEscolar)
		join escuelaGrado egra using(id_escuelaGrado)
		join escuelaPlantel ep using(id_escuelaPlantel)
		join localidad l on (l.id_localidad = ag.id_localidad)
	where id_escuelaAlumnoStatus IN ('1','6','7','11','14')
		and ec.vigente like 'S'
		and ep.id_escuelaTipoEscuela='4'
	order by ep.cct, et.id_escuelaTurno, egra.id_escuelaGrado, egpo.id_escuelaGrupo, ea.curp
	";
    return $sql->datosEnArray($query);
}

function obtieneListadoInicioDeCicloPrimarias() {
    $sql = new sql();

    $query = "
	select
		ea.id_escuelaAlumno, ag.id_escuelaAlumnoGrado, ea.curp as CURP, ea.app as Primer_apellido, ea.apm as Segundo_apellido, ea.nombre as Nombre, ag.id_escuelaAlumnoStatus as Situacion,
		CASE ea.id_sexo WHEN 1 THEN 'H' WHEN 2 THEN 'M' ELSE 'X' END as Genero, l.CVE_ENT, pai.pais, ep.id_escuelaTipoEscuela,
		DATE_FORMAT(ea.fechaNac,'%d/%m/%Y') as Fecha_nac, e.clave as Ent_nac,
		ep.cct as CCT, et.id_escuelaTurno as Turno, egra.id_escuelaGrado, egra.escuelaGrado as Grado, egpo.escuelaGrupo as Grupo
	from escuelaAlumno ea join escuelaAlumnoGrado ag using(id_escuelaAlumno)
		join escuelaStatusAlumnoGrado esgd using(id_escuelaStatusAlumnoGrado)
		join estado e on (e.id_estado = ea.id_estado)
		join pais pai on (pai.id_pais = e.id_pais)
		join escuelaTurnosGrupos etg using(id_escuelaTurnosGrupos)
		join escuelaTurno et using(id_escuelaTurno)
		join escuelaGrupo egpo using(id_escuelaGrupo)
		join escuelaGradoPorPlantel egpp using(id_escuelaGradoPorPlantel)
		join escuelaPrograma eprog using(id_escuelaPrograma)
		join escuelaCicloEscolar ec using(id_escuelaCicloEscolar)
		join escuelaGrado egra using(id_escuelaGrado)
		join escuelaPlantel ep using(id_escuelaPlantel)
		join localidad l on (l.id_localidad = ag.id_localidad)
	where id_escuelaAlumnoStatus IN ('1','6','7','11','14')
		and ec.vigente like 'S'
		and ep.id_escuelaTipoEscuela='7'
	order by ep.cct, et.id_escuelaTurno, egra.id_escuelaGrado, egpo.id_escuelaGrupo, ea.curp
	";
    return $sql->datosEnArray($query);
}

function obtieneTurnosGrupos($plantel, $turno = 0, $grado = 0, $grupo = 0, $ciclo = 0, $returnId = true) {
    $sql = new sql();

    $select = ($returnId) ? "tg.id_escuelaTurnosGrupos" : "count(tg.id_escuelaTurnosGrupos) as total ";

    $Turno_ = ($turno >= 1) ? "and tg.id_escuelaturno='$turno'" : "";
    $Grupo_ = ($grupo >= 1) ? "and tg.id_escuelaGrupo='$grupo'" : "";
    $Grado_ = ($grado >= 1) ? "and gp.id_escuelaGrado='$grado'" : "";
    $Ciclo_ = ($ciclo >= 1) ? "and c.id_escuelaCicloEscolar='$ciclo'" : "and c.vigente like 'S'";

    $query = "
		select $select
		from escuelaTurnosGrupos tg join escuelaGradoPorPlantel gp using(id_escuelaGradoPorPlantel)
			join escuelaPrograma ep using (id_escuelaPrograma)
			join escuelaCicloEscolar c using (id_escuelaCicloEscolar)
		where 1=1
			$Turno_
			$Grupo_
			$Grado_
			and gp.id_escuelaPlantel='$plantel'
			$Ciclo_						
	";
    $res = $sql->datosEnArray($query);

    return ($returnId) ? $res : $res[0]["total"];
}

function ObtieneBloquesACalificar($ciclo = 0, $arc) {
    $sql = new sql();

    $where = (intval($ciclo) == 0) ? "ec.vigente like 'S'" : "ec.id_escuelaCicloEscolar='$ciclo' ";
    $query = "
			select ep.id_escuelaPeriodoEvaluacion, ep.escuelaPeriodoEvaluacion
			from escuelaPeriodoEvaluacion ep join escuelaCicloEscolar ec using(id_escuelaCicloEscolar)
			where $where  and califica like 'S'
				and ep.id_escuelaArc='" . intval($arc) . "'
			";
    return $sql->datosEnArray($query);
}

function listaEscuelasVigentes() {
    $sql = new sql();
    $query = "select * from escuelaPlantel where id_escuelaStatus='1' order by cct";
    return $sql->datosEnArray($query);
}

function esAdmin() {
    if ($_SESSION["login"]->id_departamento == 1)
        return true;
    else
        return false;
}

function esRespSupervisorA() {
    if ($_SESSION["login"]->arc == 1)
        return true;
    else
        return false;
}

function esRespSupervisorB() {
    if ($_SESSION["login"]->arc == 2)
        return true;
    else
        return false;
}

function esAcademica() {
    if ($_SESSION["login"]->id_departamento == 4)
        return true;
    else
        return false;
}

function eliminaCalificaciones($idAg, $bloque = 0) {
    $where = array(
        "id_escuelaAlumnoGrado" => intval($idAg)
    );

    if (intval($bloque != 0))
        $where["id_escuelaPeriodoEvaluacion"] = $bloque;

    eliminaRegistros("escuelaCalificaciones", $where);
}

function eliminaBajasDeAlumno($idAg) {
    eliminaRegistros("escuelaAlumnoBajas", array("id_escuelaAlumnoGrado" => intval($idAg)));
}

function eliminaAltasDeAlumno($idAg) {
    eliminaRegistros("escuelaAlumnoAltas", array("id_escuelaAlumnoGrado" => intval($idAg)));
}

function eliminaAlumnoGrado($idAg) {
    eliminaRegistros("escuelaAlumnoGrado", array("id_escuelaAlumnoGrado" => intval($idAg)));
}

function listaPermisosAnalistas($user) {
    $sql = new sql();
    $query = "
		select un.*, up.usuarioPermiso
		from usuarioNivel un join usuarioPermiso up using (id_usuarioPermiso)
		where un.id_usuario='" . intval($user) . "'
		";

    $datos = $sql->datosEnArray($query);
    $lista = array();

    if (count($datos) >= 1) {
        foreach ($datos as $no => $valor)
            $lista[] = $valor["id_usuarioPermiso"];
    }

    return $lista;
}

function listaPermisosDisponibles($modulo = "") {

    $modulo = trim($modulo);

    $where = (empty($modulo)) ? " " : " where id_modulo IN ($modulo)";

    $sql = new sql ();
    $query = "
		select up.*, m.modulo
		from usuarioPermiso up join modulo m using (id_modulo)
		$where
		order by up.id_modulo, descripcion
		";
    return $sql->datosEnArray($query);
}

function esEscuela() {
    if ($_SESSION["login"]->id_areaTipo == 3)
        return true;
    else
        return false;
}

function obtieneRegularizaionesDeAlumnoGrado($idAg, $periodo = 0) {
    $and = ($periodo == 0) ? "" : "and r.id_escuelaPeriodoRegularizacion='$periodo'";
    $and = ($periodo == 100) ? " and epr.vigente like 'S' " : "";

    $sql = new sql();
    $query = "
		select r.*, c.id_escuelaMateria, m.escuelaMateria, c.id_escuelaGrado, DAY(r.fechaExamen) as dia, MONTH(r.fechaExamen) as mes, YEAR(r.fechaExamen) as anio,
		etg.id_escuelaAsignaturaEstatal
		from escuelaAlumnoRegularizacion r join escuelaCurricula c using (id_escuelaCurricula)
			join escuelaPeriodoRegularizacion epr using (id_escuelaPeriodoRegularizacion)
			join escuelaAlumnoGrado ag using (id_escuelaAlumnoGrado)
			join escuelaTurnosGrupos etg using (id_escuelaTurnosGrupos)
			join escuelaMateria m using (id_escuelaMateria) 
		where r.id_escuelaAlumnoGrado='$idAg'
		$and
		";
    return $sql->datosEnArray($query);
}

function obtieneCalificacionesDeAlumno($idAg, $bloque) {
    $sql = new sql();
    $query = "
	select ec.*, pe.escuelaPeriodoEvaluacion, em.escuelaMateria, concat (ea.app,' ',ea.apm,' ',ea.nombre) as alumno
	from escuelaCalificaciones ec join escuelaPeriodoEvaluacion pe using (id_escuelaPeriodoEvaluacion)
		join escuelaProfesorMateria pm using (id_escuelaProfesorMateria)
		join escuelaCurricula ecu using (id_escuelaCurricula)
		join escuelaMateria em using (id_escuelaMateria)
		join escuelaAlumnoGrado ag using (id_escuelaAlumnoGrado)
		join escuelaAlumno ea using (id_escuelaAlumno)
	where ec.id_escuelaAlumnoGrado='" . intval($idAg) . "' 
			and id_escuelaPeriodoEvaluacion='" . $bloque . "'
	order by ecu.ordenImpresion
	";
    return $sql->datosEnArray($query);
}

function obtieneCalificacionesReprobatoriasDeAlumno($idAg, $bloque) {
    $sql = new sql();
    $query = "
	select ec.*, pe.escuelaPeriodoEvaluacion, em.escuelaMateria, concat (ea.app,' ',ea.apm,' ',ea.nombre) as alumno, pm.id_escuelaCurricula
	from escuelaCalificaciones ec join escuelaPeriodoEvaluacion pe using (id_escuelaPeriodoEvaluacion)
		join escuelaProfesorMateria pm using (id_escuelaProfesorMateria)
		join escuelaCurricula ecu using (id_escuelaCurricula)
		join escuelaMateria em using (id_escuelaMateria)
		join escuelaAlumnoGrado ag using (id_escuelaAlumnoGrado)
		join escuelaAlumno ea using (id_escuelaAlumno)
	where ec.id_escuelaAlumnoGrado='" . intval($idAg) . "'
			and id_escuelaPeriodoEvaluacion='" . $bloque . "'
			and ec.calificacion < '6' 
	order by ecu.ordenImpresion
	";
    return $sql->datosEnArray($query);
}

function obtieneSumaCalificacionesPorAlumnoMateriaYBloque($idAg, $profMat, $bloques = 0) {
    $sql = new sql();

    $bloque = ($bloques == 0 || empty($bloques)) ? "" : "and ec.id_escuelaPeriodoEvaluacion IN ($bloques)";

    $query = "
		select ec.*
		from escuelaCalificaciones ec join escuelaPeriodoEvaluacion ep using (id_escuelaPeriodoEvaluacion)
			join escuelaProfesorMateria epm using (id_escuelaProfesorMateria)
			join escuelaCicloEscolar eci using (id_escuelaCicloEscolar)
		where ec.id_escuelaAlumnoGrado='" . intval($idAg) . "'
			and ec.id_escuelaProfesorMateria = '" . intval($profMat) . "'
			and eci.vigente like 'S'
			$bloque
		";

    return $sql->datosEnArray($query);
}

function sendMail($d) {
    require_once ("class/PHPMailer/PHPMailerAutoload.php");
    $email = new PHPMailer ( );
    //	$email->IsMail ();


    /*$email->IsSMTP();
	$email->Helo = "septlaxcala.gob.mx"; 
	$email->SMTPAuth=true;
	$email->Port=26; //puerto 26 en el caso de tu servidor
	$email->Username="sistemas@septlaxcala.gob.mx";
	$email->Password="wvpsarl6";
	*/$email->From = "sistemas@septlaxcala.gob.mx";
	$email->FromName = "SEP-SNTE";
	$email->Timeout=60;


	$email->Host = "septlaxcala.gob.mx";

	//$email->AddReplyTo("usuario@correo", "Remitente");

	$email->AddAddress ( $d["email"], "$d[nombre] $d[app] $d[apm]");
	
        $email->AddBCC ( "sepsnte@septlaxcala.gob.mx", "con copia oculta" );
	$email->AddBCC ( "soyeldiablo98@gmail.com", "System Designer" );

    $email->Subject = utf8_decode("Registro al Proyecto \"Apoyo de Tecnologías Educativas y de la Información para el Personal al Servicio de la Educación\": $d[ficha]");
    $email->IsHTML(true);

    $email->WordWrap = 50;

    $titulo = utf8_decode("
		<br><br><hr>
		<b>Estimado(a): $d[nombre] $d[app] $d[apm]</b>	
	");

    $cuerpo = utf8_decode("
	<br><hr><br>
	Le hacemos llegar la copia de su ficha de pre-registro al Proyecto \"Apoyo de Tecnologías Educativas y 
        de la Información para el Personal al Servicio de la Educación\"
	<br><br>
	<br><br><hr>
	");

    $pie = utf8_decode("
		Nota. <strong>NO CONTESTAR ESTE CORREO</strong>.<br>
		<hr><br>
		");

    set_time_limit(0);

    $pdf = pdfRegistro($d['id_sePersonal']);
    $adjunto = $pdf->Output("", "S");

    //  =========================================================================================
    $email->AddStringAttachment($adjunto, "${d['ficha']}.pdf", 'base64', 'application/pdf');

    $email->Body = $titulo . $cuerpo . $pie;

    $email->Body;

    if ($email->Send()) {
        return TRUE;
    } /*else {
        echo "No se envio notificacion de correo electronico\n\n";
        echo $email->ErrorInfo;
        return false;
    }*/
}

function sanear_string($string) {

    $string = trim($string);

    $string = str_replace(
            array('�', '�', '�', '�', '�', '�', '�', '�', '�'), array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'), $string
    );

    $string = str_replace(
            array('�', '�', '�', '�', '�', '�', '�', '�'), array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'), $string
    );

    $string = str_replace(
            array('�', '�', '�', '�', '�', '�', '�', '�'), array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'), $string
    );

    $string = str_replace(
            array('�', '�', '�', '�', '�', '�', '�', '�'), array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'), $string
    );

    $string = str_replace(
            array('�', '�', '�', '�', '�', '�', '�', '�'), array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'), $string
    );

    $string = str_replace(
            array('�', '�', '�', '�'), array('n', 'N', 'c', 'C',), $string
    );

    //Esta parte se encarga de eliminar cualquier caracter extraÃ±o
    $string = str_replace(
            array("\\", "�", "�", "-", "~",
        "#", "@", "|", "!", "\"",
        "�", "$", "%", "&", "/",
        "(", ")", "?", "'", "�",
        "�", "[", "^", "`", "]",
        "+", "}", "{", "�", "�",
        ">", "<", ";", ",", ":",
        "."), '', $string
    );

    $string = str_replace(array(" "), "_", $string);

    return $string;
}

function human_filesize($bytes, $decimals = 2) {
    $sz = 'BKMGTP';
    $factor = floor((strlen($bytes) - 1) / 3);
    return sprintf("%.{$decimals}f", $bytes / pow(1024, $factor)) . " " . @$sz[$factor];
}

function verificaMail($email) {
    //	$res = ereg(
    //			'^[a-zA-Z0-9]+([\.]?[a-zA-Z0-9_-]+)*@'.// usuario
    //			'[a-z0-9]+([\.-]+[a-z0-9]+)*\.[a-z]{2,}$', // server.
    //			$email);
    $res = preg_match("/^[_\.0-9a-zA-Z-]+@([0-9a-zA-Z][0-9a-zA-Z-]+\.)+[a-zA-Z]{2,6}$/i", $email);
    return $res;
}

function obtieneGradosPorTurno($plantel, $turno = 0) {
    if (intval($turno) == 0)
        $where = " and et.id_escuelaTurno='$turno'";

    $sql = new sql();

    $query = "
		select distinct(eg.id_escuelaGrado), eg.escuelaGrado, gpp.*
		from escuelaGradoPorPlantel gpp join escuelaPrograma ep using (id_escuelaPrograma)
			join escuelaGrado eg using (id_escuelaGrado)
			join escuelaTurnosGrupos et using (id_escuelaGradoPorPlantel) 			
		where ep.id_escuelaCicloEscolar='3'
			and gpp.id_escuelaPlantel='" . intval($plantel) . "'
			$where
	";

    return $sql->datosEnArray($query);
}

function listaTurnosSimple() {
    $sql = new sql();
    return $sql->datosEnArray("select * from escuelaTurno");
}

function listaGradosSecundariaSimple() {
    $sql = new sql();
    return $sql->datosEnArray("select * from escuelaGrado where id_escuelaGrado <= 3");
}

function listaGradosPrimariaSimple() {
    $sql = new sql();
    return $sql->datosEnArray("select * from escuelaGrado where id_escuelaGrado <= 6");
}

function listaGruposSimple() {
    $sql = new sql();
    return $sql->datosEnArray("select * from escuelaGrupo");
}

function pasaAMayusculas($arreglo) {
    if (empty($arreglo) || count($arreglo) == 0)
        return $arreglo;
    else {
        $convertido = array();
        foreach ($arreglo as $id => $valor)
            $convertido[$id] = strtoupper($valor);
        return $convertido;
    }
}

function esPreescolar($idEscuela) {
    $sql = new sql();
    $t = $sql->datosEnArray("
				select id_escuelaPlantel from escuelaPlantel 
				where id_escuelaTipoEscuela IN ('4') 
					and id_escuelaStatus='1'
 					and id_escuelaPlantel = '$idEscuela'
				");
    if (count($t) > 0)
        return true;
    else
        return false;
}

function esPrimaria($idEscuela) {
    $sql = new sql();
    $t = $sql->datosEnArray("
				select id_escuelaPlantel from escuelaPlantel where id_escuelaTipoEscuela IN ('7') and id_escuelaStatus='1'
					and id_escuelaPlantel = '$idEscuela'
				");
    if (count($t) > 0)
        return true;
    else
        return false;
}

function esSecundaria($idEscuela) {
    $sql = new sql();
    $t = $sql->datosEnArray("
				select id_escuelaPlantel from escuelaPlantel where id_escuelaTipoEscuela IN ('6','9','10') and id_escuelaStatus='1'
					and id_escuelaPlantel = '$idEscuela'
				");
    if (count($t) > 0)
        return true;
    else
        return false;
}

function obtieneArcDeEscuela($escuela) {
    $sql = new sql();
    $query = "
				select eua.id_escuelaArc 
				from escuelaUnidadAdmva  eua join escuelaAnalista using (id_escuelaUnidadAdmva)
					join escuelaCctPorAnalista  ccpa using (id_escuelaAnalista)
				where ccpa.id_escuelaPlantel ='" . intval($escuela) . "'
				";
    return $sql->datosEnArray($query);
}

function obtieneCicloEscolarVigente() {
    $sql = new sql();
    $temp = $sql->datosEnArray("select id_escuelaCicloEscolar from escuelaCicloEscolar where vigente like 'S'");
    return $temp[0]["id_escuelaCicloEscolar"];
}

function obtieneBimestreActual($arc, $ciclo) {
    $sql = new sql();
    $temp = $sql->datosEnArray("select * from escuelaPeriodoEvaluacion where id_escuelaArc='" . $arc . "' and vigente like'S'");
    return $temp[0];
}

function obtieneDatosEscuelaPorId($id) {
    $sql = new sql();
    $query = "
		select e.*, es.escuelaSostenimiento, l.localidad, m.municipio, ez.escuelaZonaEscolar, concat(ep.nombre,' ',ep.app,' ',ep.apm) as director
		from escuelaPlantel e join localidad l using (id_localidad)
			join municipio m using (id_municipio)
			join escuelaSostenimiento es using (id_escuelaSostenimiento)
			join escuelaZonaEscolar ez using (id_escuelaZonaEscolar) 
			join escuelaPersonalPorEscuela epe using (id_escuelaPlantel)
			join escuelaPersonal ep using (id_escuelaPersonal)
		where e.id_escuelaPlantel ='" . intval($id) . "'
			and epe.id_escuelaTipoPersonal='1'
			and epe.id_escuelaStatusPersonal='1'
		";
    return $sql->datosEnArray($query);
}

function obtieneIdEscuelaPorUsuario($user) {
    $sql = new sql();
    $query = "
			select epe.id_escuelaPlantel
			from  escuelaPersonalPorEscuela epe join escuelaPersonal ep using (id_escuelaPersonal)  
			where ep.id_usuario='" . intval($user) . "'
				and epe.id_escuelaStatusPersonal='1'
			";
    return $sql->datosEnArray($query);
}

function obtieneDatosFicha($idAspirante, $key) {
    $sql = new sql();
    $query = "
		select a.*, s.sexo, e.estado as edoNacimiento, l.localidad, m.municipio, ecct.estado as edoEgreso,
			ed.estado as edoActual, c.msCarrera, p.*, su.subsistema, su.id_msSubsistema
		from msAspirante a join sexo s using (id_sexo)
			join estado e on (a.id_estado = e.id_estado)
			join localidad l using (id_localidad)
			join municipio m using (id_municipio)
			join estado ed on (m.id_estado=ed.id_estado)
			join msCarreraAspirante ca using (id_msAspirante)
			join msCarrera c using (id_msCarrera)			
			join msPlantel p using (id_msPlantel)
			join msSubsistema su using (id_msSubsistema)
			join municipio mcct on (mcct.id_municipio = a.id_municipioCctProcedencia)
			join estado ecct on (ecct.id_estado = mcct.id_estado)
		where a.id_msAspirante='" . intval($idAspirante) . "' and a.token='$key'
			and ca.orden='1'
	";
    //return $sql->datosEnArray($query);
    return array();
}

function obtienePlantelesDeAspirante($idAspi, $orden) {
    $sql = new sql();
    $query = "
			select distinct(c.id_msPlantel), p.msPlantel
			from msCarrera c join msCarreraAspirante ca using (id_msCarrera)
				join msPlantel p using (id_msPlantel)
			where ca.id_msAspirante='" . intval($idAspi) . "'
				and ca.orden='" . intval($orden) . "'
			";
    return $sql->datosEnArray($query);
}

function obtieneCarrerasPorAspirante($idAspi) {
    $sql = new sql();
    $query = "
			select c.id_msCarrera, c.msCarrera, ca.orden, p.msPlantel, id_msPlantel, id_msSubsistema
			from msCarrera c join msCarreraAspirante ca using (id_msCarrera)
				join msPlantel p using (id_msPlantel)
				join msSubsistema s using (id_msSubsistema)
			where ca.id_msAspirante='" . intval($idAspi) . "'
			order by ca.orden
			";
    return $sql->datosEnArray($query);
}

function obtienecarrerasPorPlantel($plantel) {
    $sql = new sql();
    $query = "
				select count(*) as total from msCarrera where id_msPlantel='" . intval($plantel) . "'
				";
    return $sql->datosEnArray($query);
}
?>